package ru.yandex.iex.proxy;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IexProxyLogger {
    private static final long SEC = 1000L;
    private static final String SP = " ";

    private final Logger logLogger;

    IexProxyLogger(final Logger logger)
        throws IOException
    {
        this.logLogger = logger;
        info("logging started");
    }

    public boolean isLoggable(final Level level) {
        return logLogger.isLoggable(level);
    }

    public void info(final String msg) {
        logLogger.info(msg);
    }

    public void infoWithTime(final String msg) {
        logLogger.info("curtime=" + System.currentTimeMillis() / SEC
                + SP + msg);
    }

    public void warning(final String msg) {
        logLogger.warning(msg);
    }

    public void error(final String msg) {
        logLogger.severe(msg);
    }
}
