package ru.yandex.iex.proxy;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

import ru.yandex.iex.proxy.xutils.mailsender.limiters.IexForwardLimiterFactory;
import ru.yandex.parser.config.ConfigException;

public class ImmutableIexForwarderConfig implements IexForwarderConfig {
    private static final Pattern EMAIL =
        Pattern.compile("^yndx\\.[.\\w]+@yandex\\.ru$");
    private final String email;
    private final List<IexForwardLimiterFactory> limiters;
    private final boolean verboseLog;

    public ImmutableIexForwarderConfig(
        final IexForwarderConfig config)
        throws ConfigException
    {
        if (config.email() == null
            || !EMAIL.matcher(config.email()).matches())
        {
            throw new ConfigException(
                "Forward email should match " + EMAIL.toString()
                    + " but got " + config.email());
        }

        this.email = config.email();
        this.limiters = Collections.unmodifiableList(config.limiters());
        this.verboseLog = config.verboseLog();
    }

    @Override
    public String email() {
        return email;
    }

    @Override
    public List<IexForwardLimiterFactory> limiters() {
        return limiters;
    }

    public ImmutableIexForwarderConfig build() throws ConfigException {
        return new ImmutableIexForwarderConfig(this);
    }

    @Override
    public boolean verboseLog() {
        return verboseLog;
    }
}
