package ru.yandex.iex.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.parser.config.ConfigException;

public class ImmutableIexForwardersConfig implements IexForwardersConfig {
    private final Map<String, List<ImmutableIexForwarderConfig>> forwarders;

    public ImmutableIexForwardersConfig(
        final IexForwardersConfig config)
        throws ConfigException
    {
        LinkedHashMap<String, List<ImmutableIexForwarderConfig>> forwarders =
            new LinkedHashMap<>();

        for (String action: config.forwarders().keySet()) {
            List<ImmutableIexForwarderConfig> forwarderConfigs =
                new ArrayList<>();

            for (IexForwarderConfig forwarderConfig
                : config.forwarders().get(action))
            {
                forwarderConfigs.add(
                    new IexForwarderConfigBuilder(forwarderConfig).build());
            }

            forwarders.put(
                action,
                Collections.unmodifiableList(forwarderConfigs));
        }

        this.forwarders = Collections.unmodifiableMap(forwarders);
    }

    @Override
    public Map<String, List<ImmutableIexForwarderConfig>> forwarders() {
        return forwarders;
    }

    public List<ImmutableIexForwarderConfig> forwarder(final String name) {
        return forwarders.get(name);
    }
}
