package ru.yandex.iex.proxy;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.geocoder.ImmutableGeocoderConfig;
import ru.yandex.http.config.ImmutableFilterSearchConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.http.config.ImmutableURIConfig;
import ru.yandex.iex.proxy.afisha.config.ImmutableAfishaConfig;
import ru.yandex.iex.proxy.complaints.ImmutableComplaintsConfig;
import ru.yandex.iex.proxy.config.ImmutableSmartObjectConfig;
import ru.yandex.iex.proxy.images.ImmutableZoraProxyClientConfig;
import ru.yandex.iex.proxy.xiva.ImmutableXivaConfig;
import ru.yandex.jniwrapper.ImmutableJniWrapperConfig;
import ru.yandex.logger.ImmutableLoggerConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.mail.received.ImmutableReceivedChainParserConfig;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;
import ru.yandex.stater.ImmutableStaterConfig;

public class ImmutableIexProxyConfig extends ImmutableUniversalSearchProxyConfig implements IexProxyConfig
{
    private final ImmutableURIConfig iexConfig;
    private final ImmutableTvm2ClientConfig tvm2ClientConfig;
    private final ImmutableHttpHostConfig blackboxConfig;
    private final ImmutableHttpHostConfig corpBlackboxConfig;
    private final ImmutableHttpHostConfig blackboxDirectConfig;
    private final ImmutableHttpTargetConfig postProcessConfig;
    private final ImmutableHttpHostConfig tikaiteConfig;
    private final ImmutableHttpHostConfig tikaiteMlConfig;
    private final ImmutableHttpHostConfig mulcagateConfig;
    private final ImmutableURIConfig axisConfig;
    private final ImmutableZoraProxyClientConfig zoraProxyConfig;
    private final ImmutableURIConfig rcaURIConfig;
    private final ImmutableStaterConfig rcaStaterConfig;
    private final ImmutableURIConfig factsExtractURIConfig;
    private final ImmutableFilterSearchConfig filterSearchConfig;
    private final ImmutableFilterSearchConfig corpFilterSearchConfig;
    private final ImmutableURIConfig foldersConfig;
    private final ImmutableURIConfig corpFoldersConfig;
    private final ImmutableURIConfig labelsConfig;
    private final ImmutableURIConfig corpLabelsConfig;
    private final ImmutableURIConfig attachSidConfig;
    private final ImmutableURIConfig corpAttachSidConfig;
    private final ImmutableComplaintsConfig complaintsConfig;
    private final ImmutableURIConfig complaintsCoworkersSelectionConfig;
    private final ImmutableURIConfig sologgerConfig;
    private final ImmutableURIConfig freemailConfig;
    private final ImmutableURIConfig settingsApiConfig;
    private final ImmutableURIConfig corpSettingsApiConfig;
    private final ImmutableHttpHostConfig cokemulatorIexlibConfig;
    private final ImmutableHttpHostConfig msalConfig;
    private final ImmutableHttpHostConfig corpMsalConfig;
    private final ImmutableHttpHostConfig raspConfig;
    private final ImmutableStaterConfig raspStaterConfig;
    private final ImmutableHttpHostConfig refundConfig;
    private final ImmutableHttpHostConfig marketConfig;
    private final ImmutableHttpHostConfig bkConfig;
    private final ImmutableHttpHostConfig mediaConfig;
    private final ImmutableHttpHostConfig gettextConfig;
    private final ImmutableHttpHostConfig gatemailConfig;
    private final ImmutableHttpHostConfig calendarConfig;
    private final ImmutableHttpHostConfig calendarToolsConfig;
    private final ImmutableHttpHostConfig corovaneerConfig;
    private final ImmutableHttpHostConfig kinopoiskQlConfig;
    private final ImmutableHttpHostConfig msearchConfig;
    private final ImmutableHttpHostConfig onlineDBConfig;
    private final ImmutableHttpHostConfig reminderConfig;
    private final ImmutableGeocoderConfig geoSearchConfig;
    private final ImmutableStaterConfig geoStaterConfig;
    private final ImmutableAfishaConfig afishaConfig;
    private final ImmutableHttpHostConfig producerAsyncClientConfig;
    private final ImmutableHttpHostConfig soProducerConfig;
    private final ImmutableHttpHostConfig knnConfig;
    private final ImmutableHttpHostConfig mopsConfig;
    private final ImmutableHttpHostConfig corpMopsConfig;
    private final ImmutableIexForwardersConfig forwardersConfig;
    private final Pattern mdbs;
    private final Long maxRetries;
    private final Long almostAllFactsTimeout;
    private final Long factsExtractIndexationWaitTimeout;
    private final String slowQueueName;
    private final String factsIndexingQueueName;
    private final String xIndexOperationQueueNameFacts;
    private final String xIndexOperationQueueNameBacklog;
    private final String xIndexOperationQueueNameUpdate;
    private final String axisQueueName;
    private final String mailSearchQueueName;
    private final String corpMailSearchQueueName;
    private final IniConfig extraSettings;
    private final ImmutableLoggerConfig reqresLog;
    private final ImmutableLoggerConfig sobbYtLog;
    private final IniConfig headersSection;
    private final IniConfig headersDomainSection;
    private final IniConfig entitiesSection;
    private final IniConfig postProcessSection;
    private final IniConfig entitiesEmailSection;
    private final IniConfig postProcessEmailSection;
    private final IniConfig entitiesRcptEmailSection;
    private final IniConfig postProcessRcptEmailSection;
    private final IniConfig entitiesRcptUidSection;
    private final IniConfig postProcessRcptUidSection;
    private final IniConfig rcptUidRuleSections;
    private final IniConfig entitiesDomainSection;
    private final IniConfig postProcessDomainSection;
    private final IniConfig rcptUidStoreSignalsSection;
    private final IniConfig entitiesTimeStamps;
    private final IniConfig urlsWhitelistRegexp;
    private final IniConfig mediaFiscalsProperties;
    private final IniConfig refundSendersProperties;
    private final Set<String> factNamesToEraseFactData;
    private final ImmutableXivaConfig xivaConfig;
    private final ImmutableXivaConfig xivaCorpConfig;
    private final ImmutableHttpHostConfig taksaConfig;
    private final ImmutableHttpHostConfig taksaTestingConfig;
    private final ImmutableHttpHostConfig neuroHardsConfig;
    private final ImmutableReceivedChainParserConfig receivedChainParserConfig;
    private final String blackboxTvmClientId;
    private final String corpBlackboxTvmClientId;
    private final String tikaiteTvmClientId;
    private final String unistorageTvmClientId;
    private final String geoTvmClientId;
    private final String afishaTvmClientId;
    private final String kinopoiskTvmClientId;
    private final String filterSearchTvmClientId;
    private final String corpFilterSearchTvmClientId;
    private final String foldersTvmClientId;
    private final String corpFoldersTvmClientId;
    private final String labelsTvmClientId;
    private final String corpLabelsTvmClientId;
    private final String attachSidTvmClientId;
    private final String corpAttachSidTvmClientId;
    private final String taksaTvmClientId;
    private final String calendarTvmClientId;
    private final String calendarToolsTvmClientId;
    private final String corovaneerTvmClientId;
    private final String mopsTvmClientId;
    private final String corpMopsTvmClientId;
    private final String settingsApiTvmClientId;
    private final String corpSettingsApiTvmClientId;
    private final String soService;
    private final boolean enlarge;
    private final ImmutableJniWrapperConfig unpersonConfig;
    private final ImmutableSmartObjectConfig smartObjectConfig;

    public ImmutableIexProxyConfig(final IexProxyConfig config)
        throws ConfigException, IOException
    {
        super(config);
        forceTvm2ServiceConfig();
        iexConfig = new ImmutableURIConfig(config.iexConfig());
        tvm2ClientConfig = new ImmutableTvm2ClientConfig(config.tvm2ClientConfig());
        blackboxConfig = new ImmutableHttpHostConfig(config.blackboxConfig());
        corpBlackboxConfig = new ImmutableHttpHostConfig(config.corpBlackboxConfig());
        blackboxDirectConfig = new ImmutableHttpHostConfig(config.blackboxDirectConfig());
        postProcessConfig = new ImmutableHttpTargetConfig(config.postProcessConfig());
        tikaiteConfig = new ImmutableHttpHostConfig(config.tikaiteConfig());
        tikaiteMlConfig = new ImmutableHttpHostConfig(config.tikaiteMlConfig());
        mulcagateConfig = new ImmutableHttpHostConfig(config.mulcagateConfig());
        axisConfig = new ImmutableURIConfig(config.axisConfig());
        complaintsConfig = new ImmutableComplaintsConfig(config.complaintsConfig());
        complaintsCoworkersSelectionConfig = new ImmutableURIConfig(config.complaintsCoworkersSelectionConfig());
        sologgerConfig = new ImmutableURIConfig(config.sologgerConfig());
        freemailConfig = new ImmutableURIConfig(config.freemailConfig());
        settingsApiConfig = new ImmutableURIConfig(config.settingsApiConfig());
        corpSettingsApiConfig = new ImmutableURIConfig(config.corpSettingsApiConfig());
        zoraProxyConfig = new ImmutableZoraProxyClientConfig(config.zoraProxyConfig());
        rcaURIConfig = new ImmutableURIConfig(config.rcaURIConfig());
        rcaStaterConfig = new ImmutableStaterConfig(config.rcaStaterConfig());
        factsExtractURIConfig = new ImmutableURIConfig(config.factsExtractURIConfig());
        filterSearchConfig = new ImmutableFilterSearchConfig(config.filterSearchConfig());
        corpFilterSearchConfig = new ImmutableFilterSearchConfig(config.corpFilterSearchConfig());
        foldersConfig = new ImmutableURIConfig(config.foldersConfig());
        corpFoldersConfig = new ImmutableURIConfig(config.corpFoldersConfig());
        labelsConfig = new ImmutableURIConfig(config.labelsConfig());
        corpLabelsConfig = new ImmutableURIConfig(config.corpLabelsConfig());
        attachSidConfig = new ImmutableURIConfig(config.attachSidConfig());
        corpAttachSidConfig = new ImmutableURIConfig(config.corpAttachSidConfig());
        forwardersConfig = new ImmutableIexForwardersConfig(config.forwardersConfig());
        smartObjectConfig = new ImmutableSmartObjectConfig(config.smartObjectConfig());

        mdbs = config.mdbs();
        almostAllFactsTimeout = config.almostAllFactsTimeout();
        factsExtractIndexationWaitTimeout = config.factsExtractIndexationWaitTimeout();

        if (config.producerAsyncClientConfig() != null) {
            producerAsyncClientConfig = new ImmutableHttpHostConfig(config.producerAsyncClientConfig());
            maxRetries = config.maxRetries();
            slowQueueName = config.slowQueueName();
        } else {
            producerAsyncClientConfig = null;
            maxRetries = null;
            slowQueueName = null;
        }

        if (producerClientConfig() == null) {
            throw new ConfigException("There are no parameters for producerClient in config");
        }

        factsIndexingQueueName = config.factsIndexingQueueName();
        xIndexOperationQueueNameBacklog = config.xIndexOperationQueueNameBacklog();
        xIndexOperationQueueNameFacts = config.xIndexOperationQueueNameFacts();
        xIndexOperationQueueNameUpdate = config.xIndexOperationQueueNameUpdate();
        axisQueueName = config.axisQueueName();
        if (axisQueueName == null) {
            throw new ConfigException("There is no parameter for axis queue name in config");
        }
        if (axisQueueName.isEmpty()) {
            throw new ConfigException("Parameter for axis queue name in config is empty");
        }
        mailSearchQueueName = config.mailSearchQueueName();
        corpMailSearchQueueName = config.corpMailSearchQueueName();
        cokemulatorIexlibConfig = new ImmutableHttpHostConfig(config.cokemulatorIexlibConfig());
        msalConfig = new ImmutableHttpHostConfig(config.msalConfig());
        corpMsalConfig = new ImmutableHttpHostConfig(config.corpMsalConfig());
        raspConfig = new ImmutableHttpHostConfig(config.raspConfig());
        raspStaterConfig = new ImmutableStaterConfig(config.raspStaterConfig());
        refundConfig = new ImmutableHttpHostConfig(config.refundConfig());
        marketConfig = new ImmutableHttpHostConfig(config.marketConfig());
        bkConfig = new ImmutableHttpHostConfig(config.bkConfig());
        mediaConfig = new ImmutableHttpHostConfig(config.mediaConfig());
        gettextConfig = new ImmutableHttpHostConfig(config.gettextConfig());
        gatemailConfig = new ImmutableHttpHostConfig(config.gatemailConfig());
        calendarConfig = new ImmutableHttpHostConfig(config.calendarConfig());
        calendarToolsConfig = new ImmutableHttpHostConfig(config.calendarToolsConfig());
        corovaneerConfig = new ImmutableHttpHostConfig(config.corovaneerConfig());
        kinopoiskQlConfig = new ImmutableHttpHostConfig(config.kinopoiskQlConfig());
        msearchConfig = new ImmutableHttpHostConfig(config.msearchConfig());
        onlineDBConfig = new ImmutableHttpHostConfig(config.onlineDBConfig());
        reminderConfig = new ImmutableHttpHostConfig(config.reminderConfig());
        geoSearchConfig = new ImmutableGeocoderConfig(config.geoSearchConfig());
        geoStaterConfig = new ImmutableStaterConfig(config.geoStaterConfig());
        afishaConfig = new ImmutableAfishaConfig(config.afishaConfig());
        reqresLog = new ImmutableLoggerConfig(config.reqresLog());
        sobbYtLog = new ImmutableLoggerConfig(config.sobbYtLog());
        extraSettings = config.extraSettingsConfig();
        headersSection = config.headersSection();
        headersDomainSection = config.headersDomainSection();
        entitiesSection = config.entitiesSection();
        postProcessSection = config.postProcessSection();
        entitiesEmailSection = config.entitiesEmailSection();
        postProcessEmailSection = config.postProcessEmailSection();
        entitiesRcptEmailSection = config.entitiesRcptEmailSection();
        postProcessRcptEmailSection = config.postProcessRcptEmailSection();
        entitiesDomainSection = config.entitiesDomainSection();
        postProcessDomainSection = config.postProcessDomainSection();
        entitiesRcptUidSection = config.entitiesRcptUidSection();
        postProcessRcptUidSection = config.postProcessRcptUidSection();
        rcptUidRuleSections = config.rcptUidRuleSections();
        rcptUidStoreSignalsSection = config.rcptUidStoreSignalsSection();
        entitiesTimeStamps = config.entitiesTimeStamps();
        urlsWhitelistRegexp = config.urlsWhitelistRegexp();
        mediaFiscalsProperties = config.mediaFiscalsProperties();
        refundSendersProperties = config.refundSendersProperties();
        factNamesToEraseFactData = Collections.unmodifiableSet(config.factNamesToEraseFactData());
        xivaConfig = new ImmutableXivaConfig(config.xivaConfig());
        xivaCorpConfig = new ImmutableXivaConfig(config.xivaCorpConfig());
        taksaConfig = new ImmutableHttpHostConfig(config.taksaConfig());
        taksaTestingConfig = new ImmutableHttpHostConfig(config.taksaTestingConfig());
        neuroHardsConfig = new ImmutableHttpHostConfig(config.neuroHardsConfig());
        receivedChainParserConfig = new ImmutableReceivedChainParserConfig(config.receivedChainParserConfig());
        blackboxTvmClientId = config.blackboxTvmClientId();
        corpBlackboxTvmClientId = config.corpBlackboxTvmClientId();
        tikaiteTvmClientId = config.tikaiteTvmClientId();
        unistorageTvmClientId = config.unistorageTvmClientId();
        geoTvmClientId = config.geoTvmClientId();
        afishaTvmClientId = config.afishaTvmClientId();
        kinopoiskTvmClientId = config.kinopoiskTvmClientId();
        filterSearchTvmClientId = config.filterSearchTvmClientId();
        corpFilterSearchTvmClientId = config.corpFilterSearchTvmClientId();
        foldersTvmClientId = config.foldersTvmClientId();
        corpFoldersTvmClientId = config.corpFoldersTvmClientId();
        labelsTvmClientId = config.labelsTvmClientId();
        corpLabelsTvmClientId = config.corpLabelsTvmClientId();
        attachSidTvmClientId = config.attachSidTvmClientId();
        corpAttachSidTvmClientId = config.corpAttachSidTvmClientId();
        taksaTvmClientId = config.taksaTvmClientId();
        calendarTvmClientId = config.calendarTvmClientId();
        calendarToolsTvmClientId = config.calendarToolsTvmClientId();
        corovaneerTvmClientId = config.corovaneerTvmClientId();
        mopsTvmClientId = config.mopsTvmClientId();
        corpMopsTvmClientId = config.corpMopsTvmClientId();
        settingsApiTvmClientId = config.settingsApiTvmClientId();
        corpSettingsApiTvmClientId = config.corpSettingsApiTvmClientId();
        soService = config.soService();
        if (soService != null) {
            soProducerConfig = new ImmutableHttpHostConfig(config.soProducerConfig());
        } else {
            soProducerConfig = null;
        }
        knnConfig = new ImmutableHttpHostConfig(config.knnConfig());
        mopsConfig = new ImmutableHttpHostConfig(config.mopsConfig());
        corpMopsConfig = new ImmutableHttpHostConfig(config.corpMopsConfig());
        enlarge = config.enlarge();
        unpersonConfig = new ImmutableJniWrapperConfig(config.unpersonConfig());
    }

    @Override
    public ImmutableHttpHostConfig cokemulatorIexlibConfig() {
        return cokemulatorIexlibConfig;
    }

    @Override
    public ImmutableHttpHostConfig msalConfig() {
        return msalConfig;
    }

    @Override
    public ImmutableHttpHostConfig corpMsalConfig() {
        return corpMsalConfig;
    }

    @Override
    public ImmutableHttpHostConfig raspConfig() {
        return raspConfig;
    }

    @Override
    public ImmutableStaterConfig raspStaterConfig() {
        return raspStaterConfig;
    }

    @Override
    public ImmutableHttpHostConfig refundConfig() {
        return refundConfig;
    }

    @Override
    public ImmutableHttpHostConfig marketConfig() {
        return marketConfig;
    }

    @Override
    public ImmutableHttpHostConfig bkConfig() {
        return bkConfig;
    }

    @Override
    public ImmutableHttpHostConfig mediaConfig() {
        return mediaConfig;
    }

    @Override
    public ImmutableHttpHostConfig gettextConfig() {
        return gettextConfig;
    }

    @Override
    public ImmutableHttpHostConfig gatemailConfig() {
        return gatemailConfig;
    }

    @Override
    public ImmutableHttpHostConfig msearchConfig() {
        return msearchConfig;
    }

    @Override
    public ImmutableHttpHostConfig onlineDBConfig() {
        return onlineDBConfig;
    }

    @Override
    public ImmutableHttpHostConfig reminderConfig() {
        return reminderConfig;
    }

    @Override
    public ImmutableHttpHostConfig calendarConfig() {
        return calendarConfig;
    }

    @Override
    public ImmutableHttpHostConfig calendarToolsConfig() {
        return calendarToolsConfig;
    }

    @Override
    public ImmutableHttpHostConfig corovaneerConfig() {
        return corovaneerConfig;
    }

    @Override
    public ImmutableHttpHostConfig kinopoiskQlConfig() {
        return kinopoiskQlConfig;
    }

    @Override
    public ImmutableGeocoderConfig geoSearchConfig() {
        return geoSearchConfig;
    }

    @Override
    public ImmutableStaterConfig geoStaterConfig() {
        return geoStaterConfig;
    }

    @Override
    public ImmutableAfishaConfig afishaConfig() {
        return afishaConfig;
    }

    @Override
    public ImmutableURIConfig iexConfig() {
        return iexConfig;
    }

    @Override
    public ImmutableTvm2ClientConfig tvm2ClientConfig() {
        return tvm2ClientConfig;
    }

    @Override
    public ImmutableHttpHostConfig blackboxConfig() {
        return blackboxConfig;
    }

    @Override
    public ImmutableHttpHostConfig corpBlackboxConfig() {
        return corpBlackboxConfig;
    }

    @Override
    public ImmutableHttpHostConfig blackboxDirectConfig() {
        return blackboxDirectConfig;
    }

    @Override
    public ImmutableHttpTargetConfig postProcessConfig() {
        return postProcessConfig;
    }

    @Override
    public ImmutableHttpHostConfig tikaiteConfig() {
        return tikaiteConfig;
    }

    @Override
    public ImmutableHttpHostConfig tikaiteMlConfig() {
        return tikaiteMlConfig;
    }

    @Override
    public ImmutableHttpHostConfig mulcagateConfig() {
        return mulcagateConfig;
    }

    @Override
    public ImmutableFilterSearchConfig filterSearchConfig() {
        return filterSearchConfig;
    }

    @Override
    public ImmutableFilterSearchConfig corpFilterSearchConfig() {
        return corpFilterSearchConfig;
    }

    @Override
    public ImmutableURIConfig foldersConfig() {
        return foldersConfig;
    }

    @Override
    public ImmutableURIConfig corpFoldersConfig() {
        return corpFoldersConfig;
    }

    @Override
    public ImmutableURIConfig labelsConfig() {
        return labelsConfig;
    }

    @Override
    public ImmutableURIConfig corpLabelsConfig() {
        return corpLabelsConfig;
    }

    @Override
    public ImmutableURIConfig attachSidConfig() {
        return attachSidConfig;
    }

    @Override
    public ImmutableURIConfig corpAttachSidConfig() {
        return corpAttachSidConfig;
    }

    @Override
    public ImmutableURIConfig axisConfig() {
        return axisConfig;
    }

    @Override
    public ImmutableComplaintsConfig complaintsConfig() {
        return complaintsConfig;
    }

    @Override
    public ImmutableURIConfig complaintsCoworkersSelectionConfig() {
        return complaintsCoworkersSelectionConfig;
    }

    @Override
    public ImmutableURIConfig sologgerConfig() {
        return sologgerConfig;
    }

    @Override
    public ImmutableURIConfig freemailConfig() {
        return freemailConfig;
    }

    @Override
    public ImmutableURIConfig settingsApiConfig() {
        return settingsApiConfig;
    }

    @Override
    public ImmutableURIConfig corpSettingsApiConfig() {
        return corpSettingsApiConfig;
    }

    @Override
    public ImmutableURIConfig rcaURIConfig() {
        return rcaURIConfig;
    }

    @Override
    public ImmutableStaterConfig rcaStaterConfig() {
        return rcaStaterConfig;
    }

    @Override
    public ImmutableURIConfig factsExtractURIConfig() {
        return factsExtractURIConfig;
    }

    @Override
    public Pattern mdbs() {
        return mdbs;
    }

    @Override
    public ImmutableHttpHostConfig producerAsyncClientConfig() {
        return producerAsyncClientConfig;
    }

    @Override
    public ImmutableHttpHostConfig soProducerConfig() {
        return soProducerConfig;
    }

    @Override
    public ImmutableHttpHostConfig knnConfig() {
        return knnConfig;
    }

    @Override
    public ImmutableHttpHostConfig mopsConfig() {
        return mopsConfig;
    }

    @Override
    public ImmutableHttpHostConfig corpMopsConfig() {
        return corpMopsConfig;
    }

    @Override
    public Long maxRetries() {
        return maxRetries;
    }

    @Override
    public Long almostAllFactsTimeout() {
        return almostAllFactsTimeout;
    }

    @Override
    public String axisQueueName() {
        return axisQueueName;
    }

    @Override
    public String slowQueueName() {
        return slowQueueName;
    }

    @Override
    public String factsIndexingQueueName() {
        return factsIndexingQueueName;
    }

    @Override
    public String xIndexOperationQueueNameBacklog() {
        return xIndexOperationQueueNameBacklog;
    }

    @Override
    public String xIndexOperationQueueNameFacts() {
        return xIndexOperationQueueNameFacts;
    }

    @Override
    public String xIndexOperationQueueNameUpdate() {
        return xIndexOperationQueueNameUpdate;
    }

    @Override
    public String mailSearchQueueName() {
        return mailSearchQueueName;
    }

    @Override
    public String corpMailSearchQueueName() {
        return corpMailSearchQueueName;
    }

    @Override
    public ImmutableLoggerConfig reqresLog() {
        return reqresLog;
    }

    @Override
    public ImmutableLoggerConfig sobbYtLog() {
        return sobbYtLog;
    }

    @Override
    public IniConfig extraSettingsConfig()
        throws ConfigException
    {
        return extraSettings;
    }

    @Override
    public IniConfig headersSection() {
        return headersSection;
    }

    @Override
    public IniConfig headersDomainSection() {
        return headersDomainSection;
    }

    @Override
    public IniConfig entitiesSection() {
        return entitiesSection;
    }

    @Override
    public IniConfig postProcessSection() {
        return postProcessSection;
    }

    @Override
    public IniConfig entitiesEmailSection() {
        return entitiesEmailSection;
    }

    @Override
    public IniConfig postProcessEmailSection() {
        return postProcessEmailSection;
    }

    @Override
    public IniConfig entitiesRcptEmailSection() {
        return entitiesRcptEmailSection;
    }

    @Override
    public IniConfig postProcessRcptEmailSection() {
        return postProcessRcptEmailSection;
    }

    @Override
    public IniConfig entitiesRcptUidSection() {
        return entitiesRcptUidSection;
    }

    @Override
    public IniConfig postProcessRcptUidSection() {
        return postProcessRcptUidSection;
    }

    @Override
    public IniConfig rcptUidRuleSections() {
        return rcptUidRuleSections;
    }

    @Override
    public IniConfig entitiesDomainSection() {
        return entitiesDomainSection;
    }

    @Override
    public IniConfig postProcessDomainSection() {
        return postProcessDomainSection;
    }

    @Override
    public IniConfig rcptUidStoreSignalsSection() {
        return rcptUidStoreSignalsSection;
    }

    @Override
    public IniConfig entitiesTimeStamps() {
        return entitiesTimeStamps;
    }

    @Override
    public IniConfig urlsWhitelistRegexp() {
        return urlsWhitelistRegexp;
    }

    @Override
    public IniConfig mediaFiscalsProperties() {
        return mediaFiscalsProperties;
    }

    @Override
    public IniConfig refundSendersProperties() {
        return refundSendersProperties;
    }

    @Override
    public ImmutableZoraProxyClientConfig zoraProxyConfig() {
        return zoraProxyConfig;
    }

    @Override
    public Set<String> factNamesToEraseFactData() {
        return factNamesToEraseFactData;
    }

    @Override
    public ImmutableIexForwardersConfig forwardersConfig() {
        return forwardersConfig;
    }

    @Override
    public ImmutableXivaConfig xivaConfig() {
        return xivaConfig;
    }

    @Override
    public ImmutableXivaConfig xivaCorpConfig() {
        return xivaCorpConfig;
    }

    @Override
    public ImmutableHttpHostConfig taksaConfig() {
        return taksaConfig;
    }

    @Override
    public ImmutableHttpHostConfig taksaTestingConfig() {
        return taksaTestingConfig;
    }

    @Override
    public ImmutableHttpHostConfig neuroHardsConfig() {
        return neuroHardsConfig;
    }

    @Override
    public Long factsExtractIndexationWaitTimeout() {
        return factsExtractIndexationWaitTimeout;
    }

    @Override
    public String blackboxTvmClientId() {
        return blackboxTvmClientId;
    }

    @Override
    public String corpBlackboxTvmClientId() {
        return corpBlackboxTvmClientId;
    }

    @Override
    public String tikaiteTvmClientId() {
        return tikaiteTvmClientId;
    }

    @Override
    public String unistorageTvmClientId() {
        return unistorageTvmClientId;
    }

    @Override
    public String geoTvmClientId() {
        return geoTvmClientId;
    }

    @Override
    public String afishaTvmClientId() {
        return afishaTvmClientId;
    }

    @Override
    public String kinopoiskTvmClientId() {
        return kinopoiskTvmClientId;
    }

    @Override
    public String filterSearchTvmClientId() {
        return filterSearchTvmClientId;
    }

    @Override
    public String corpFilterSearchTvmClientId() {
        return corpFilterSearchTvmClientId;
    }

    @Override
    public String foldersTvmClientId() {
        return foldersTvmClientId;
    }

    @Override
    public String corpFoldersTvmClientId() {
        return corpFoldersTvmClientId;
    }

    @Override
    public String labelsTvmClientId() {
        return labelsTvmClientId;
    }

    @Override
    public String corpLabelsTvmClientId() {
        return corpLabelsTvmClientId;
    }

    @Override
    public String attachSidTvmClientId() {
        return attachSidTvmClientId;
    }

    @Override
    public String corpAttachSidTvmClientId() {
        return corpAttachSidTvmClientId;
    }

    @Override
    public String taksaTvmClientId() {
        return taksaTvmClientId;
    }

    @Override
    public String calendarTvmClientId() {
        return calendarTvmClientId;
    }

    @Override
    public String calendarToolsTvmClientId() {
        return calendarToolsTvmClientId;
    }

    @Override
    public String corovaneerTvmClientId() {
        return corovaneerTvmClientId;
    }

    @Override
    public String mopsTvmClientId() {
        return mopsTvmClientId;
    }

    @Override
    public String corpMopsTvmClientId() {
        return corpMopsTvmClientId;
    }

    @Override
    public String settingsApiTvmClientId() {
        return settingsApiTvmClientId;
    }

    @Override
    public String corpSettingsApiTvmClientId() {
        return corpSettingsApiTvmClientId;
    }

    @Override
    public String soService() {
        return soService;
    }

    @Override
    public boolean enlarge() {
        return enlarge;
    }

    @Override
    public ImmutableReceivedChainParserConfig receivedChainParserConfig() {
        return receivedChainParserConfig;
    }

    @Override
    public ImmutableJniWrapperConfig unpersonConfig() {
        return unpersonConfig;
    }

    @Override
    public ImmutableSmartObjectConfig smartObjectConfig() {
        return smartObjectConfig;
    }
}
