package ru.yandex.iex.proxy;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

import ru.yandex.parser.email.types.MessageType;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.string.Parser;

public class MessageTypesCodeOrEnumParser implements Parser<MessageType> {
    private final Map<String, MessageType> bindMap;
    private final EnumParser<MessageType> enumParser =
        new EnumParser<>(MessageType.class);
    private Logger logger;

    public MessageTypesCodeOrEnumParser(final Logger logger) {
        this.logger = logger;
        Map<String, MessageType> bindMap = new LinkedHashMap<>();
        for (MessageType type: MessageType.values()) {
            bindMap.put(String.valueOf(type.typeNumber()), type);
        }
        this.bindMap = Collections.unmodifiableMap(bindMap);
    }

    @Override
    public MessageType parse(final String value) throws Exception {
        MessageType result = null;
        if (value != null && !value.isEmpty()) {
            result = this.bindMap.get(value.trim());
            if (result == null) {
                try {
                    result = enumParser.apply(value);
                } catch (IllegalArgumentException e) {
                    if (logger != null) {
                        logger.warning(
                            "No message type with code or name " + value);
                    }
                }
            }
        }
        return result;
    }
}
