package ru.yandex.iex.proxy;

import java.util.Map;

import ru.yandex.iex.proxy.eventtickethandler.EventCallback;
import ru.yandex.iex.proxy.eventtickethandler.EventTicketContext;
import ru.yandex.iex.proxy.eventtickethandler.EventTicketHandler;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class MicroEventCallback extends EventCallback {
    public static final String UNKNOWN = "unknown";
    public static final String MICRO = "micro";
    private MicroInfoParser microParser = new MicroInfoParser();

    public MicroEventCallback(final EventCallback callback) {
        super(callback);
    }

    @Override
    public void act(final EventTicketContext context) {
        try {
            Object microIn = XJsonUtils.getNodeByPathOrNull(
                context.getInputJson(),
                MICRO,
                UNKNOWN);
            if (!microParser.isEventReservation(microIn)) {
                microIn = null;
            }
            if (microIn instanceof Map) {
                microParser.parse(microIn, context.getOutputJson());
                context.getOutputJson().put(
                    EventTicketHandler.WIDGET_SUBTYPE,
                    EventTicketHandler.CINEMA);
                context.getOutputJson().put(EventTicketHandler.ORIGIN, MICRO);
                context.getOutputJson().put(
                    EventTicketHandler.RAW_DATA,
                    microIn);
            }
        } catch (JsonUnexpectedTokenException e) {
        }
    }
}
