package ru.yandex.iex.proxy;

import java.util.Map;

import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class MicroInfoParser extends CinemaInfoParser {
    public static final String TYPE = "@type";

    @Override
    public void parse(final Object in, final Map<String, Object> out) {
        super.parse(in, out);
    }

    public boolean isEventReservation(final Object json)
        throws JsonUnexpectedTokenException
    {
        if (json instanceof Map) {
            Map<?, ?> micro = ValueUtils.asMap(json);
            if (micro.containsKey(TYPE)) {
                String vl = ValueUtils.asString(micro.get(TYPE));
                return vl.equals("EventReservation");
            }
        }
        return false;
    }
}
