package ru.yandex.iex.proxy;

import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.blackbox.BlackboxDbfield;
import ru.yandex.blackbox.BlackboxEmailsType;
import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.blackbox.BlackboxUserinfoRequest;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.json.parser.JsonException;

public class ModifyHandler implements ActionHandler {
    public void handle(final HandlersContext context)
        throws HttpException, JsonException
    {
        context.cancelled(this);
    }

    public static void indexDocument(
        final AbstractContext context,
        final FutureCallback<? super List<BlackboxUserinfo>> callback)
    {
        BlackboxClient client;
        BlackboxUserinfoRequest request =
            new BlackboxUserinfoRequest(context.prefixType(), context.prefix())
            .emailsType(BlackboxEmailsType.GETALL)
            .requiredDbfields(BlackboxDbfield.MDB, BlackboxDbfield.SUID);
        if (context.corp()) {
            client = context.iexProxy().corpBlackboxClient();
            request.addHeader(
                YandexHeaders.X_YA_SERVICE_TICKET,
                context.iexProxy().corpBlackboxTvm2Ticket());
        } else {
            client = context.iexProxy().blackboxClient();
            request.addHeader(
                YandexHeaders.X_YA_SERVICE_TICKET,
                context.iexProxy().blackboxTvm2Ticket());
        }
        client = client.adjust(context.session().context());
        client.userinfo(
            request,
            context.session().listener().createContextGeneratorFor(client),
            callback);
    }
}

