package ru.yandex.iex.proxy;

import java.util.logging.Level;

public class MsalCallback extends AbstractCallback<Object> {
    public MsalCallback(final IndexationContext<Object> context) {
        super(context);
    }

    public void completed(final Object result) {
        //Input: msal response
        //Output: empty - endpoint
        context().abstractContext()
            .session().logger().info("Msal response: " + result);
        context().callback().completed(null);
    }

    public void cancelled() {
        context().abstractContext()
            .session().logger().info("Msal request cancelled");
        context.callback().cancelled();
    }

    public void failed(final Exception e) {
        context().abstractContext()
            .session().logger().info("Msal request failed");
        context().abstractContext()
            .session().logger()
            .log(Level.WARNING, "test", e);
        context.callback().failed(e);
    }
}

