package ru.yandex.iex.proxy;

import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.collection.IntPair;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.AsyncStringConsumerFactory;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCodeAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;

public class MulcaGateDataRequest extends StorageDataSubRequest {
    public static final String EML = "eml";

    public MulcaGateDataRequest(
        final IndexationContext<Solution> context,
        final FutureCallback<StorageRequestResult> callback)
    {
        super(context, callback);
    }

    @Override
    public String wrapKey() {
        return "";
    }

    @Override
    public String hid() {
        return "";
    }

    @Override
    public boolean partRequest() {
        return false;
    }

    @Override
    public void registerExecutionTime(final long time) {
    }

    @Override
    public void execute() {
        execute(new StringToStorageResultConverter(this));
    }

    protected void execute(final FutureCallback<IntPair<String>> callback) {
        final IexProxy iexProxy =
            indexationContext().abstractContext().iexProxy();
        final AsyncClient client =
            iexProxy.mulcagateClient()
                .adjust(
                    indexationContext().abstractContext().session().context());

        client.execute(
            iexProxy.mulcagateHost(),
            mulcaGateRequest(),
            new StatusCheckAsyncResponseConsumerFactory<IntPair<String>>(
                x -> x < HttpStatus.SC_BAD_REQUEST
                || x == HttpStatus.SC_NOT_FOUND
                || x == HttpStatus.SC_LOCKED,
                new StatusCodeAsyncConsumerFactory<String>(
                    AsyncStringConsumerFactory.INSTANCE)),
            indexationContext().abstractContext().session().listener()
                .createContextGeneratorFor(client),
            callback);
    }

    protected BasicAsyncRequestProducerGenerator mulcaGateRequest() {
        BasicAsyncRequestProducerGenerator producerGenerator =
            new BasicAsyncRequestProducerGenerator(
                "/gate/get/" + indexationContext().stid());
        producerGenerator.addHeader(
            YandexHeaders.X_YA_SERVICE_TICKET,
            context.abstractContext().iexProxy().unistorageTvm2Ticket());

        return producerGenerator;
    }

    private static class StringToStorageResultConverter
        extends AbstractFilterFutureCallback<IntPair<String>, Object>
    {
        StringToStorageResultConverter(
            final FutureCallback<Object> callback)
        {
            super(callback);
        }

        @Override
        public void completed(final IntPair<String> response) {
            final StorageRequestResult result =
                new StorageRequestResult();
            final StorageRequestResult text = new StorageRequestResult();
            text.put("message_body", response.second());
            result.put(EML, text);
            callback.completed(result);
        }
    }
}
