package ru.yandex.iex.proxy;

import org.apache.http.concurrent.FutureCallback;

public class OracleCallbackAdapter implements FutureCallback<Solution> {
    private final ChangeHandler handler;
    private final OracleContext context;

    public OracleCallbackAdapter(
        final ChangeHandler handler,
        final OracleContext context)
    {
        this.handler = handler;
        this.context = context;
    }

    public void cancelled() {
        this.context.cancelled(this.handler);
    }

    public void completed(final Solution result) {
        this.context.completed(this.handler);
    }

    public void failed(final Exception e) {
        this.context.failed(this.handler, e);
    }
}

