package ru.yandex.iex.proxy;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.blackbox.BlackboxUserIdType;
import ru.yandex.dbfields.ChangeType;
import ru.yandex.dbfields.OracleFields;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.HttpExceptionConverter;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class OracleContext extends AbstractContext {
    private static final String HANDLING = "Handling ";
    private static final String MS = " ms";
    private static final double MILLIS = 1000.0D;
    private final long start = System.currentTimeMillis();
    private final long prefix;
    private final ChangeType changeType;
    private final Long lcn;
    private final int offset;
    private final boolean isTteot;
    private final boolean zooQueueIsIexUpdate;
    private final boolean addReindexToAxis;
    private final List<String> updateCache;

    public OracleContext(
            final IexProxy iexProxy,
            final ProxySession session,
            final Map<?, ?> json
    )
        throws HttpException, JsonUnexpectedTokenException
    {
        this(iexProxy, session, json, false, false, false, null);
    }

    // CSOFF: ParameterNumber
    public OracleContext(
            final IexProxy iexProxy,
            final ProxySession session,
            final Map<?, ?> json,
            final boolean isTteot,
            final boolean zooQueueIsIexUpdate,
            final boolean addReindexToAxis,
            final List<String> updateCache
    )
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        prefix = ValueUtils.asLong(json.get("uname"));
        changeType = ChangeType.STORE;
        lcn = ValueUtils.asLongOrNull(json.get(OracleFields.LCN));
        this.offset = 0;
        this.isTteot = isTteot;
        this.zooQueueIsIexUpdate = zooQueueIsIexUpdate;
        this.addReindexToAxis = addReindexToAxis;
        this.updateCache = updateCache;
    }
    // CSON: ParameterNumber

    public long prefix() {
        return this.prefix;
    }

    public BlackboxUserIdType prefixType() {
        return BlackboxUserIdType.SUID;
    }

    public boolean prefixUrl() {
        return true;
    }

    public ChangeType changeType() {
        return this.changeType;
    }

    public Long lcn() {
        return lcn;
    }

    public int offset() {
        return this.offset;
    }

    public boolean isTteot() {
        return isTteot;
    }

    public boolean zooQueueIsIexUpdate() {
        return zooQueueIsIexUpdate;
    }

    public boolean addReindexToAxis() {
        return addReindexToAxis;
    }

    public List<String> updateCache() {
        return updateCache;
    }

    public void cancelled(final ChangeHandler handler) {
        this.session.logger().info(HANDLING
                + handler
                + " cancelled after "
                + (System.currentTimeMillis() - this.start)
                + MS);
        this.subrequestCompleted();
    }

    public void completed(final ChangeHandler handler) {
        this.session.logger().info(HANDLING
                + handler
                + " completed after "
                + (System.currentTimeMillis() - this.start)
                + MS);
        this.subrequestCompleted();
    }

    public void failed(final ChangeHandler handler, final Exception e) {
        this.session.logger().log(Level.WARNING, HANDLING
                + handler
                + " failed to process:\n"
                + this.humanReadableJson()
                + "\nafter "
                + (System.currentTimeMillis() - this.start)
                + " ms:\n" + this.session.listener().details(), e);
        session.handleException(HttpExceptionConverter.toHttpException(e));
    }

    private void subrequestCompleted() {
        this.session.response(HttpStatus.SC_OK);
    }
}
