package ru.yandex.iex.proxy;

import java.util.regex.Pattern;

public final class OutputDebugger {
    private static int level = detectLevel();
    private static boolean enabled;

    private OutputDebugger() {
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(final boolean enabled) {
        OutputDebugger.enabled = enabled;
    }

    public static void log(final Object o) {
        System.out.println(o.toString());
    }

    public static void op(final Object o) {
        OutputDebugger.setEnabled(true);
        if (isEnabled()) {
            StackTraceElement[] stackTrace =
                    new Throwable().getStackTrace();
            String callerFilePath = stackTrace[1].getClassName();
            String[] lcal = callerFilePath.split(Pattern.quote("."));
            log(lcal[lcal.length - 1] + " log:");
            log("   " + o);
            log(lineOut());
        }
    }

    public static String lineOut() {
        final StackTraceElement[] trace =
            Thread.currentThread().getStackTrace();
        return new StringBuilder(" at " + trace[level]).append(" ").toString();
    }

    private static int detectLevel() {
        final StackTraceElement[] st = Thread.currentThread().getStackTrace();
        final String thisName = "OutputDebugger";
        int level = 0;
        for (StackTraceElement e : st) {
            final String eClassName = e.getClassName();
            if (!eClassName.contains(thisName)
                && !eClassName.startsWith("java.lang.Thread"))
            {
                break;
            }
            level++;
        }
        return level;
    }
}
