package ru.yandex.iex.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.iex.proxy.eventtickethandler.EventCallback;
import ru.yandex.iex.proxy.eventtickethandler.EventTicketContext;
import ru.yandex.iex.proxy.eventtickethandler.EventTicketHandler;

public class PdfGetHidsCallback extends EventCallback {
    private static final String HID_PDF = "hid_pdf";
    private HashMap<String, Object> solution = new HashMap<>();

    public PdfGetHidsCallback(final EventCallback callback) {
        super(callback);
    }

    @Override
    public void act(final EventTicketContext context) {
        List<Object> res = new ArrayList<>();
        for (Map.Entry<String, Object> x
            : context.getInputJson().entrySet())
        {
            if (x.getKey().startsWith("pdf")) {
                Object v = x.getValue();
                if (v instanceof Map) {
                    Map<?, ?> m = XJsonUtils.asMap(v);
                    if (m.containsKey(HID_PDF)) {
                        res.add(m.get(HID_PDF));
                    }
                }
            }
        }
        if (!res.isEmpty()) {
            solution.put(EventTicketHandler.PRINT_PARTS, res);
            context.setNewSolution(
                XJsonUtils.mergeJson(solution, context.getOutputJson()));
        }
    }
}
