package ru.yandex.iex.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.iex.proxy.eventtickethandler.EventCallback;
import ru.yandex.iex.proxy.eventtickethandler.EventParser;
import ru.yandex.iex.proxy.eventtickethandler.EventTicketContext;
import ru.yandex.iex.proxy.eventtickethandler.EventTicketHandler;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;

public class PkpassAttachCallback extends EventCallback {
    private static final String PKPASS = "pkpass";
    private static final String HID_PKPASS = "hid_pkpass";
    private EventParser cinemaParser = new CinemaInfoParser();

    public PkpassAttachCallback(final EventCallback callback) {
        super(callback);
    }

    @Override
    public void act(final EventTicketContext context) {
        Map<String, Object> input = context.getInputJson();
        Map<String, Object> solution = context.getOutputJson();
        try {
            HashMap<String, Object> pkpassSolution = new HashMap<>();
            Object attachPkpass =
                XJsonUtils.getNodeByPathOrNull(
                    input,
                    PKPASS,
                    "getbody",
                    "text");
            if (attachPkpass instanceof String) {
                attachPkpass =
                    TypesafeValueContentHandler.parse(
                        (String) attachPkpass).asMap();
            }
            if (attachPkpass instanceof Map) {
                cinemaParser.parse(
                    attachPkpass,
                    pkpassSolution);
                pkpassSolution.put(
                    EventTicketHandler.WIDGET_SUBTYPE,
                    EventTicketHandler.CINEMA);
                pkpassSolution.put(EventTicketHandler.ORIGIN, PKPASS);
                pkpassSolution.put(
                    EventTicketHandler.DOMAIN,
                    context.getDomain());
                pkpassSolution.put(
                    EventTicketHandler.IEX_MSG,
                    "not eticket, but maybe");
                List<Object> pkpassAttachHids = new ArrayList<>();
                for (Map.Entry<String, Object> x
                    : context.getInputJson().entrySet())
                {
                    if (x.getKey().startsWith(PKPASS)) {
                        Object v = x.getValue();
                        if (v instanceof Map) {
                            Map<?, ?> m = XJsonUtils.asMap(v);
                            if (m.containsKey(HID_PKPASS)) {
                                pkpassAttachHids.add(m.get(HID_PKPASS));
                            }
                        }
                    }
                }
                if (!pkpassAttachHids.isEmpty()) {
                    pkpassSolution.put(
                        EventTicketHandler.SPECIAL_PARTS,
                        pkpassAttachHids);
                }
                pkpassSolution.put(EventTicketHandler.RAW_DATA, attachPkpass);
            }
            if (!pkpassSolution.isEmpty()) {
                context.setNewSolution(
                    XJsonUtils.mergeJson(pkpassSolution, solution));
            }
        } catch (JsonException ignored) {
        }
    }
}
