package ru.yandex.iex.proxy;

public class PostProcessAction {
    public static final String VOID = "_VOID";
    private final String url;
    private final String name;
    private final boolean isVoid;

    public PostProcessAction(final String url, final String name) {
        this.url = url;
        this.name = name;
        isVoid = name.equals(VOID);
    }

    public String url() {
        return url;
    }

    public String name() {
        return name;
    }

    public boolean isVoid() {
        return isVoid;
    }

    @Override
    public int hashCode() {
        return url.hashCode() ^ name.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof PostProcessAction) {
            final PostProcessAction other = (PostProcessAction) o;
            return other.name().equals(name) && other.url().equals(url);
        }
        return false;
    }

    @Override
    public String toString() {
        return "PostProcessAction:[url=" + url + ", name=" + name + ']';
    }
}

