package ru.yandex.iex.proxy;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.json.dom.JsonObject;

public class RequestWithJsonResultCallback
    implements FutureCallback<JsonObject>
{
    protected final String request;
    protected final FutureCallback<RequestWithJsonResult> callback;

    RequestWithJsonResultCallback(
        final String request,
        final FutureCallback<RequestWithJsonResult> callback)
    {
        this.request = request;
        this.callback = callback;
    }

    public String getRequest() {
        return request;
    }

    @Override
    public void cancelled() {
        callback.cancelled();
    }

    @Override
    public void failed(final Exception e) {
        callback.failed(e);
    }

    @Override
    public void completed(final JsonObject result) {
        callback.completed(new RequestWithJsonResult(request, result));
    }
}
