package ru.yandex.iex.proxy;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.BadResponseException;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.stater.RequestInfo;
import ru.yandex.util.timesource.TimeSource;

public class RequestWithRcaResultCallback
    extends RequestWithJsonResultCallback
{
    private final long start = TimeSource.INSTANCE.currentTimeMillis();
    private final IexProxy iexProxy;

    RequestWithRcaResultCallback(
        final String request,
        final FutureCallback<RequestWithJsonResult> callback,
        final IexProxy iexProxy)
    {
        super(request, callback);
        this.iexProxy = iexProxy;
    }

    @Override
    public void cancelled() {
        stat(YandexHttpStatus.SC_CLIENT_CLOSED_REQUEST);
        callback.cancelled();
    }

    @Override
    public void failed(final Exception e) {
        if (e instanceof BadResponseException) {
            stat(((BadResponseException) e).statusCode());
        } else {
            stat(YandexHttpStatus.SC_REMOTE_CLOSED_REQUEST);
        }
        callback.failed(e);
    }

    @Override
    public void completed(final JsonObject result) {
        try {
            JsonMap mapResult = result.asMap();
            if (mapResult.size() > 2) {
                stat(YandexHttpStatus.SC_OK);
                iexProxy.rcaRequestCompleted(false);
            } else { // only 'url' and 'favicon' fields, i.e. empty result
                stat(YandexHttpStatus.SC_OK);
                iexProxy.rcaRequestCompleted(true);
            }
        } catch (JsonException ignored) {
        }
        callback.completed(new RequestWithJsonResult(request, result));
    }

    private void stat(final int status) {
        iexProxy.rcaRequestsStater().accept(
            new RequestInfo(
                TimeSource.INSTANCE.currentTimeMillis(),
                status,
                start,
                start,
                0L,
                0L));
    }
}

