package ru.yandex.iex.proxy;

import java.util.HashMap;
import java.util.Map;

public class Solution {
    private final IndexationContext<Solution> context;
    private Map<String, Object> cokemulatorSolutions;
    private Map<String, Object> postActionSolutions = null;

    public Solution(
        final IndexationContext<Solution> context,
        final Map<String, Object> cokemulatorSolutions)
    {
        this.context = context;
        this.cokemulatorSolutions = cokemulatorSolutions;
    }

    //public void addCokemulatorSolution(final)

    public void addSolution(final PostActionWithResult solution) {
        if (postActionSolutions == null) {
            postActionSolutions = new HashMap<>();
        }
        postActionSolutions.put(solution.action().name(), solution.result());
    }

    public IndexationContext<Solution> context() {
        return context;
    }

    public Map<String, Object> cokemulatorSolutions() {
        return cokemulatorSolutions;
    }

    public Map<String, Object> postActionSolutions() {
        if (postActionSolutions == null) {
            postActionSolutions = new HashMap<>();
        }
        return postActionSolutions;
    }

    public boolean isEmpty() {
        if (cokemulatorSolutions.isEmpty()) {
            return true;
        }
        boolean empty = true;
        for (final Map.Entry<String, Object> entry
            : cokemulatorSolutions.entrySet())
        {
            if (entry.getKey().equals("refund_fbl") || entry.getValue() != null) {
                empty = false;
                break;
            }
        }
        return empty;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Solution for ");
        sb.append(context.mid());
        sb.append(" uid ");
        sb.append(context.uid());
        sb.append(" coke: ");
        sb.append(cokemulatorSolutions);
        sb.append(", post: ");
        sb.append(postActionSolutions);
        return new String(sb);
    }
}
