package ru.yandex.iex.proxy;

import java.util.Map;
import java.util.logging.Logger;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public abstract class StorageDataSubRequest
    implements FutureCallback<Object>, IndexationContextable<Solution>
{
    protected final IndexationContext<Solution> context;
    protected final FutureCallback<StorageRequestResult> callback;
    protected final long startTime;

    public StorageDataSubRequest(
        final IndexationContext<Solution> context,
        final FutureCallback<StorageRequestResult> callback)
    {
        this.context = context;
        this.callback = callback;
        this.startTime = System.currentTimeMillis();
    }

    public Logger logger() {
        return context.abstractContext().session().logger();
    }

    @Override
    public IndexationContext<Solution> indexationContext() {
        return context;
    }

    public abstract void registerExecutionTime(final long time);

    public abstract void execute();

    public abstract boolean partRequest();

    public String hidName() {
        if (hid().isEmpty()) {
            return "";
        } else {
            return "hid_" + wrapKey();
        }
    }

    public abstract String hid();

    public abstract String wrapKey();

    @Override
    public void completed(final Object result) {
        final StorageRequestResult requestResult = new StorageRequestResult();
        if (result instanceof Map) {
            try {
                StorageRequestResult copy;
                if (!wrapKey().isEmpty()) {
                    copy = new StorageRequestResult();
                    requestResult.put(wrapKey(), copy);
                } else {
                    copy = requestResult;
                }
                for (final Map.Entry<?, ?> x
                    : ValueUtils.asMap(result).entrySet())
                {
                    copy.put(
                        ValueUtils.asString(x.getKey()),
                        x.getValue());
                }
                if (partRequest()) {
                    copy.put(hidName(), hid());
                }
            } catch (JsonUnexpectedTokenException e) {
            }
        } else if (result instanceof String) {
            requestResult.put(Blackbox2CokemulatorCallback.PDF, result);
        }
        registerExecutionTime(System.currentTimeMillis() - startTime);
        callback.completed(requestResult);
    }

    @Override
    public void cancelled() {
        callback.cancelled();
    }

    @Override
    public void failed(final Exception e) {
        registerExecutionTime(System.currentTimeMillis() - startTime);
        callback.failed(e);
    }

    public BasicAsyncRequestProducerGenerator cokemulatorRequest(
        final String entities)
    {
        StringBuilder url = new StringBuilder();
        url.append("/process?stid=");
        url.append(context.stid());
        url.append(iexUriParams(entities));
        BasicAsyncRequestProducerGenerator producerGenerator =
            new BasicAsyncRequestProducerGenerator(new String(url));
        producerGenerator.addHeader(
            YandexHeaders.X_YA_SERVICE_TICKET,
            context.abstractContext().iexProxy().tikaiteTvm2Ticket());
        producerGenerator.addHeader(
            YandexHeaders.X_SRW_SERVICE_TICKET,
            context.abstractContext().iexProxy().unistorageTvm2Ticket());
        return producerGenerator;
    }

    public String iexUriParams(
        final String entities)
    {
        StringBuilder url = new StringBuilder();
        url.append("&time=");
        url.append(context.receivedDate());
        url.append("&domain=");
        url.append(context.domain());
        url.append("&e=");
        url.append(entities);
        return new String(url);
    }
}
