package ru.yandex.iex.proxy;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class TikaiteCompoundTextHandler implements TikaiteDomJsonHandler {
    private final StringBuilder text = new StringBuilder();
    private final String hid;

    public TikaiteCompoundTextHandler(final String hid) {
        this.hid = hid;
    }

    @Override
    public void accept(final JsonObject value) throws JsonException {
        if (!(value.type() == JsonObject.Type.MAP)) {
            throw new JsonException("Value expected to be map: " + value);
        }
        JsonMap root = value.asMap();
        String hidText = root.get("hid").asString();
        if (hidText.startsWith(hid)) {
            String[] filedsToGet = {"body_text", "pure_body", "headers"};
            JsonObject body;
            for (final String x : filedsToGet) {
                body = root.get(x);
                if (body.type() != JsonObject.Type.NULL) {
                    if (text.length() > 0) {
                        text.append('\n');
                    }
                    text.append(body.asString());
                }
            }
        }
    }

    @Override
    public String text() {
        return new String(text);
    }
}
