package ru.yandex.iex.proxy;

import ru.yandex.function.GenericConsumer;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public interface TikaiteDomJsonHandler
    extends GenericConsumer<JsonObject, JsonException>
{
    @Override
    void accept(final JsonObject value) throws JsonException;

    String text();

    static TikaiteDomJsonHandler create(final String hid) {
        if (hid.indexOf('.') == -1) {
            return new TikaiteCompoundTextHandler(hid);
        } else {
            return new TikaiteSingleHidTextHandler(hid);
        }
    }
}

