package ru.yandex.iex.proxy;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;

public abstract class TikaiteGetBodyRequest
    extends StorageDataSubRequest
    implements TikaiteRequestBase<String>
{
    public static final String GETBODY = "getbody";

    public TikaiteGetBodyRequest(
        final IndexationContext<Solution> context,
        final FutureCallback<StorageRequestResult> callback)
    {
        super(context, callback);
    }

    @Override
    public void execute() {
        execute(new StringToStorageResultConverter(this));
    }

    @Override
    public HttpAsyncResponseConsumerFactory<String>
        tikaiteResponseConsumerFactory()
    {
        return TikaiteTextConsumerFactory.ok(hid());
    }

    @Override
    public String getFields() {
        return "body_text,pure_body,headers";
    }

    private static class StringToStorageResultConverter
        extends AbstractFilterFutureCallback<String, Object>
    {
        StringToStorageResultConverter(
            final FutureCallback<Object> callback)
        {
            super(callback);
        }

        @Override
        public void completed(final String body) {
            final StorageRequestResult result =
                new StorageRequestResult();
            final StorageRequestResult text = new StorageRequestResult();
            text.put("text", body);
            result.put(GETBODY, text);
            callback.completed(result);
        }
    }
}
