package ru.yandex.iex.proxy;

import java.net.URISyntaxException;

import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.nio.client.AsyncPostURIRequestProducerSupplier;
import ru.yandex.json.async.consumer.JsonAsyncDomConsumerFactory;

public abstract class TikaiteIexProxyRequest extends TikaiteGetBodyRequest {
    public TikaiteIexProxyRequest(
        final IndexationContext<Solution> context,
        final FutureCallback<StorageRequestResult> callback)
    {
        super(context, callback);
    }

    @Override
    public abstract void execute();

    public void execute(final String entities) {
        execute(new TikaiteResponseCallback(context, entities));
    }

    @Override
    public boolean partRequest() {
        return true;
    }

    @SuppressWarnings("FutureReturnValueIgnored")
    private void iexSrvRequest(
        final String body,
        final String entities)
    {
        final IexProxy iexProxy = context.abstractContext().iexProxy();
        final AsyncClient client =
            iexProxy.iexClient()
                .adjust(context.abstractContext().session().context());
        final AsyncPostURIRequestProducerSupplier post;
        try {
            final String uri = iexProxy.config().iexConfig().uri()
                + "?rasp=false&proxy=iex&hid=" + hid() + iexUriParams(entities);
            post =
                new AsyncPostURIRequestProducerSupplier(
                    uri,
                    body,
                    ContentType.APPLICATION_JSON);
        } catch (URISyntaxException e) {
            callback.failed(e);
            return;
        }
        client.execute(
//            iexProxy.iexHost(),
            post,
            JsonAsyncDomConsumerFactory.OK,
            context.abstractContext().session().listener()
                .createContextGeneratorFor(client),
            this);
    }

    private class TikaiteResponseCallback
        extends AbstractProxySessionCallback<String>
    {
        private final String entities;

        TikaiteResponseCallback(
            final IndexationContext<Solution> context,
            final String entities)
        {
            super(context.abstractContext().session());
            this.entities = entities;
        }

        @Override
        public void completed(final String response) {
//            System.err.println("BODY: " + response);
            iexSrvRequest(response, entities);
        }
    }
}
