package ru.yandex.iex.proxy;

import java.util.List;

import org.apache.http.HttpHost;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.NotFoundException;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.mail.search.MailSearchDefaults;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.prefix.LongPrefix;

public interface TikaiteRequestBase<T> extends IndexationContextable<Solution> {
    @SuppressWarnings("FutureReturnValueIgnored")
    default void execute(final FutureCallback<T> callback) {
        final IexProxy iexProxy =
            indexationContext().abstractContext().iexProxy();
        final AsyncClient client =
            iexProxy.tikaiteClient()
                .adjust(
                    indexationContext().abstractContext().session().context());

        User user =
            new User(
                MailSearchDefaults.BP_CHANGE_LOG,
                new LongPrefix(indexationContext().uidLong()));

        List<HttpHost> hosts =
            iexProxy.searchMap().indexerHosts(user);
        if (hosts.isEmpty()) {
            String hostsNotFoundMessage =
                "Indexer hosts is empty for uid: " + indexationContext().uid()
                + ", service: " + user.service() + ", shard: " + user.shard();
            iexProxy.logger().warning(hostsNotFoundMessage);
            callback.failed(new NotFoundException(hostsNotFoundMessage));
        } else {
            client.execute(
                hosts,
                tikaiteRequest(),
                tikaiteResponseConsumerFactory(),
                indexationContext().abstractContext().session().listener()
                    .createContextGeneratorFor(client),
                callback);
        }
    }

    default void adjustUri(final StringBuilder uri) {
    }

    default String getFields() {
        return "*";
    }

    default BasicAsyncRequestProducerGenerator tikaiteRequest() {
        final StringBuilder uri = new StringBuilder();
        uri.append("/tikaite?json-type=dollar&stid=");
        uri.append(indexationContext().stid());
        String getFields = getFields();
        if (getFields.isEmpty()) {
            uri.append("&get=");
            uri.append(getFields);
        }
        adjustUri(uri);
        BasicAsyncRequestProducerGenerator producerGenerator =
            new BasicAsyncRequestProducerGenerator(new String(uri));
        producerGenerator.addHeader(
            YandexHeaders.X_YA_SERVICE_TICKET,
            indexationContext().abstractContext().iexProxy()
                .tikaiteTvm2Ticket());
        producerGenerator.addHeader(
            YandexHeaders.X_SRW_SERVICE_TICKET,
            indexationContext().abstractContext().iexProxy()
                .unistorageTvm2Ticket());
        return producerGenerator;
    }

    HttpAsyncResponseConsumerFactory<T> tikaiteResponseConsumerFactory();
}
