package ru.yandex.iex.proxy;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.util.string.StringUtils;

public class TikaiteSingleHidTextHandler implements TikaiteDomJsonHandler {
    private final String hid;
    private String text = "";

    public TikaiteSingleHidTextHandler(final String hid) {
        this.hid = hid;
    }

    @Override
    public void accept(final JsonObject value) throws JsonException {
        JsonMap root = value.asMap();
        if (root.get("hid").asString().equals(hid)) {
            String body = root.getString("body_text", "");
            text = body;
            body = root.getString("pure_body", "");
            if (!body.isEmpty()) {
                if (text.isEmpty()) {
                    text = body;
                } else {
                    text = StringUtils.concat(text, '\n', body);
                }
            }
        }
    }

    @Override
    public String text() {
        return text;
    }
}
