package ru.yandex.iex.proxy;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.StringCollectorsFactory;

public class TikaiteTextConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<String>
{
    private final TikaiteDomJsonHandler handler;

    public TikaiteTextConsumer(
        final HttpEntity entity,
        final String hid)
        throws HttpException
    {
        this(entity, TikaiteDomJsonHandler.create(hid));
    }

    private TikaiteTextConsumer(
        final HttpEntity entity,
        final TikaiteDomJsonHandler handler)
        throws HttpException
    {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);

        this.handler = handler;
    }

    @Override
    protected String buildResult(
        final HttpContext context,
        final JsonObject root)
        throws Exception
    {
        JsonList docs;
        if (root instanceof JsonMap) {
            docs = root.asMap().getList("docs");
        } else {
            docs = root.asList();
        }

        for (JsonObject obj: docs) {
            handler.accept(obj);
        }

        return handler.text();
    }
}
