package ru.yandex.iex.proxy;

import java.util.function.IntPredicate;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public class TikaiteTextConsumerFactory
    implements HttpAsyncResponseConsumerFactory<String>
{
    private final String hid;

    protected TikaiteTextConsumerFactory(final String hid) {
        this.hid = hid;
    }

    public static HttpAsyncResponseConsumerFactory<String> instance(
        final String hid,
        final IntPredicate statusPredicates)
    {
        return new StatusCheckAsyncResponseConsumerFactory<String>(
            statusPredicates,
            new TikaiteTextConsumerFactory(hid));
    }

    public static HttpAsyncResponseConsumerFactory<String> ok(
        final String hid)
    {
        return new StatusCheckAsyncResponseConsumerFactory<String>(
            HttpStatusPredicates.OK,
            new TikaiteTextConsumerFactory(hid));
    }

    @Override
    public TikaiteTextConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new TikaiteTextConsumer(response.getEntity(), hid);
    }
}
