package ru.yandex.iex.proxy;

import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.parser.uri.CgiParams;

public class TopContext extends AbstractEntityContext {
    private static final int CONTENT_LINE_MAX_LENGTH = 360;

    private final String stid;
    private final String firstline;
    private final String contentline;

    public TopContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        CgiParams params = session.params();
        stid = params.getString("stid");
        firstline = params.getString("firstline", "");

        Object clJson = (Object) json.get("contentline");
        String contentline = "";
        if (clJson instanceof Map) {
            Map<?, ?> clMap = (Map<?, ?>) clJson;
            Object clObject = clMap.get("text");
            if (clObject != null) {
                contentline = truncateContentLine(clObject.toString().trim());
            }
        }
        this.contentline = contentline;
    }

    public String stid() {
        return stid;
    }

    public String firstline() {
        return firstline;
    }

    public String contentline() {
        return contentline;
    }

    private static String truncateContentLine(final String cl) {
        return cl.substring(
            0,
            Math.min(CONTENT_LINE_MAX_LENGTH, cl.length()));
    }
}
