package ru.yandex.iex.proxy;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;

import ru.yandex.collection.LazyList;
import ru.yandex.function.ByteArrayProcessable;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.iex.proxy.xutils.spamreport.SpamReportSender;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.util.string.StringUtils;

public class TopHandler extends AbstractEntityHandler<TopContext> {
    public TopHandler(final IexProxy iexProxy) {
        super(iexProxy, "top");
    }

    @Override
    protected TopContext createContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new TopContext(iexProxy, session, json);
    }

    @Override
    protected void handle(final TopContext context) {
        context.session().logger().info("Requesting eml for " + context.stid());
        SpamReportSender.sendGetEmlRequest(
            context.iexProxy(),
            context.session(),
            context.stid(),
            new EmlCallback(context));
    }

    private static class EmlCallback
        extends AbstractProxySessionCallback<ByteArrayProcessable>
    {
        private final TopContext context;

        EmlCallback(final TopContext context) {
            super(context.session());
            this.context = context;
        }

        @Override
        public void completed(final ByteArrayProcessable result) {
            String firstline = context.firstline();
            String contentline = context.contentline();
            String humanDatePref = new SimpleDateFormat(
                "yyyy.MM.dd HH:mm:ss: ",
                Locale.US)
                .format(new Date(context.getReceivedDate() * 1000));
            String subject = humanDatePref + context.getSubject();
            try {
                QueryConstructor qc = new QueryConstructor("/send-mail?");
                String rfcDate =
                    new SimpleDateFormat(
                        "E, d MMM yyyy HH:mm:ss Z",
                        Locale.US)
                            .format(new Date(context.getReceivedDate() * 1000));

                qc.append("to", "so-compains@yandex.ru");
                qc.append(
                    "msg-to",
                    context.getEmail() + ", " + context.uid() + "@uid.ya");
                qc.append("from", context.getFrom());
                qc.append("subject", subject);
                qc.append(
                    "header",
                    "Date: " + rfcDate);
                qc.append(
                    "header",
                    "x-yandex-bigmen-email: " + context.getEmail());
                qc.append(
                    "header",
                    "x-is-bigmen-email: 1");
                qc.append(
                    "header",
                    "X-Yandex-Timestamp: " + context.getReceivedDate());
                qc.append(
                    "header",
                    "Message-Id: <uid:"
                    + context.uid() + "/stid:" + context.stid()
                    + "/received:" + context.getReceivedDate() + '>');
                qc.append(
                    "header",
                    "x-yandex-mid: " + context.getMid());
                qc.append(
                    "types",
                    StringUtils.join(
                        new LazyList<>(
                            new ArrayList<>(context.getTypes()),
                            x -> Integer.toString(x.typeNumber())),
                        ','));

                MultipartEntityBuilder builder =
                    MultipartEntityBuilder.create();
                builder.setStrictMode();
                builder.setCharset(StandardCharsets.UTF_8);
                builder.setMimeSubtype("mixed");
                builder.setBoundary("my_lucky_boundary");
                builder.addPart(
                    FormBodyPartBuilder.create()
                        .setBody(
                            new StringBody(
                                "Subject <" + subject + ">\nFirstline <"
                                + firstline + ">\nContent line <"
                                + contentline + '>',
                                ContentType.TEXT_PLAIN.withCharset("utf-8")))
                        .addField("Content-Disposition", "inline")
                        .setName("body")
                        .build());
                builder.addPart(
                    FormBodyPartBuilder.create()
                        .setBody(
                            result.processWith(
                                SpamReportSender.ByteArrayBodyFactory.INSTANCE))
                        .setName("mail.eml")
                        .addField(
                            "Content-Disposition",
                            "attachment; filename=mail.eml")
                        .build());
                HttpEntity entity = builder.build();
                qc.append(
                    "content-type",
                    entity.getContentType().getValue());
                qc.append("raw", "true");

                BasicAsyncRequestProducerGenerator generator =
                    new BasicAsyncRequestProducerGenerator(
                        qc.toString(),
                        builder.build());
                AsyncClient client =
                    context.iexProxy().gatemailClient().adjust(
                        context.session().context());
                client.execute(
                    context.iexProxy().config()
                        .gatemailConfig().host(),
                    generator,
                    EmptyAsyncConsumerFactory.NON_FATAL,
                    context.session().listener()
                        .createContextGeneratorFor(client),
                    new Callback(context.session()));
            } catch (BadRequestException|IOException e) {
                context.session().logger().log(
                    Level.WARNING,
                    "TopHandler: Failed to construct sendmail context",
                    e);
                context.session().response(YandexHttpStatus.SC_OK);
            }
        }
    }

    private static class Callback
        extends AbstractProxySessionCallback<Object>
    {
        Callback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Object result) {
            session.logger().info("Mail info reported");
            session.response(HttpStatus.SC_OK, "{}");
        }
    }
}

