package ru.yandex.iex.proxy;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.blackbox.SingleUserinfoBlackboxCallback;
import ru.yandex.dbfields.ChangeType;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;
import ru.yandex.search.document.mail.FirstlineMailMetaInfo;

public enum UpdateHandler implements ChangeHandler {
    INSTANCE;

    public static final String MID = "mid";
    public static final String UID = "uid";
    public static final String MIDS = "mids";
    public static final String STID = "stid";

    @Override
    public void handle(final ChangeContext context)
        throws BadRequestException, JsonUnexpectedTokenException
    {
        ModifyHandler.indexDocument(
            context,
            new SingleUserinfoBlackboxCallback(
                new BlackboxCallback(
                    new FactsCachingCallback(
                        new OffsetCallback(context, true)))));
        if (context.changeType() == ChangeType.STORE) {
            context.iexProxy.rcptUidStoreEvent(context.prefix());
        }
    }

    public static void index(final FactsCachingCallback callback) {
        try {
            ChangeContext changeContext = callback.changeContext();
            Set<String> mids = new HashSet<>();
            for (int i = 0; i < callback.batchSize(); ++i) {
                mids.add(ValueUtils.asString(
                    ValueUtils.asMap(
                        callback.changed()
                            .get(i + changeContext.offset()))
                            .get(MID)));
            }
            //undup
            new FilterSearchCallback(changeContext, callback, mids)
                .execute();
        } catch (JsonUnexpectedTokenException e) {
            callback.failed(new BadRequestException(e));
        }
    }

    private static class FilterSearchCallback
        extends AbstractFilterSearchCallback<Solution>
    {
        private final FactsCachingCallback factsCachingCallback;

        FilterSearchCallback(
            final AbstractContext context,
            final FactsCachingCallback callback,
            final Set<String> mids)
        {
            super(context, callback, mids);
            factsCachingCallback = callback;
        }

        @Override
        public AbstractCallback<Solution> subMessageCallback(
            final IndexationContext<Solution> ctx)
        {
            return new NotifyCallback(ctx);
        }

        @Override
        public void executeSubCallback(
            final AbstractCallback<Solution> callback)
        {
            Blackbox2CokemulatorCallback.cokemulatorExecuter(callback);
        }

        @Override
        public void addMetasWithEmptyFacts(
            final List<FirstlineMailMetaInfo> metas)
        {
            factsCachingCallback.addMetasWithEmptyFacts(metas);
        }
    }

    private static class BlackboxCallback
        extends AbstractFilterFutureCallback<BlackboxUserinfo, List<Solution>>
    {
        protected final FactsCachingCallback callback;

        BlackboxCallback(final FactsCachingCallback callback) {
            super(callback);
            this.callback = callback;
        }

        @Override
        public void completed(final BlackboxUserinfo userinfo) {
            callback.context().setUserInfo(userinfo);
            index(callback);
        }
    }
}

