package ru.yandex.iex.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.json.dom.JsonString;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public final class XJsonUtils {
    private XJsonUtils() {
    }

//    public static void putIfExist(
//        final String key,
//        final Map<?, ?> in,
//        final String newKey,
//        final Map<String, Object> out)
//    {
//        if (in.containsKey(key)) {
//            out.put(newKey, in.get(key));
//        }
//    }

    public static void putAllAndResolveNameConflicts(
        final Map<String, Object> out,
        final Map<String, Object> in,
        final Map<String, Integer> conflictTable)
    {
        String curKey;
        for (Map.Entry<String, Object> x : in.entrySet()) {
            curKey = x.getKey();
            if (conflictTable.containsKey(curKey)) {
                int num = conflictTable.get(curKey) + 1;
                conflictTable.put(curKey, num);
                curKey += '_' + String.valueOf(num);
            } else {
                conflictTable.put(curKey, 0);
            }
            out.put(curKey, x.getValue());
        }
    }

    public static String asStringOrNull(final Object o) {
        String res = null;
        try {
            if (o instanceof String) {
                res = ValueUtils.asString(o);
            } else if (o instanceof JsonString) {
                res = ((JsonString) o).asString();
            }
        } catch (JsonUnexpectedTokenException e) {
        }
        return res;
    }

    public static void addValueByPath(
        final Object out,
        final String path,
        final Object value)
    {
        String[] paths = path.split("\\.");
        Object cur = out;
        for (int i = 0; i < paths.length; ++i) {
            if (cur instanceof Map) {
                Map<?, ?> m = (Map<?, ?>) cur;
                try {
                    if (i == paths.length - 1) {
                        pushToMap(m, paths[i], value);
                    } else {
                        if (m.containsKey(paths[i])
                            && (m.get(paths[i]) instanceof Map))
                        {
                            cur = m.get(paths[i]);
                        } else {
                            cur = new HashMap<String, Object>();
                            pushToMap(m, paths[i], cur);
                        }
                    }
                } catch (JsonUnexpectedTokenException e) {
                }
            } else {
                break;
            }
        }
    }

    public static void flattenJson(
        final String prefix,
        final Object json,
        final Map<String, Object> flatMap)
    {
        if (json == null) {
            if (prefix.isEmpty()) {
                flatMap.put("empty_solution", "true");
            } else {
                flatMap.put(prefix, "null");
            }
        } else {
            final String keyPrefix;
            if (prefix.isEmpty()) {
                keyPrefix = prefix;
            } else {
                keyPrefix = prefix + '.';
            }
            if (json instanceof Map) {
                final Map<?, ?> root = (Map<?, ?>) json;
                for (final Map.Entry<?, ?> entry : root.entrySet()) {
                    final Object key = entry.getKey();
                    if (!(key instanceof String)) {
                        continue;
                    }
                    final String keyString = (String) key;
                    flattenJson(
                        keyPrefix + keyString,
                        entry.getValue(),
                        flatMap);
                }
            } else if (json instanceof List) {
                final List<?> root = (List<?>) json;
                if (prefix.isEmpty()) {
                    //root iex solution is enclosed in []
                    //skip all solutions except the first one
                    if (!root.isEmpty()) {
                        flattenJson(prefix, root.get(0), flatMap);
                    }
                } else {
                    int i = 0;
                    for (final Object value : root) {
                        flattenJson(keyPrefix + i++, value, flatMap);
                    }
                }
            } else {
                //push-client's python based conterter does not supports
                //Numbers in json
                flatMap.put(prefix, json.toString());
            }
        }
    }

    public static void getFlatJson(
        final Map<?, ?> in,
        final Map<String, Object> out,
        final String prefix)
    {
        for (final Map.Entry<?, ?> x : in.entrySet()) {
            Object key = x.getKey();
            Object value = x.getValue();
            if (key instanceof String) {
                if (value instanceof String) {
                    out.put(prefix + key, value);
                } else if (value instanceof Map) {
                    getFlatJson((Map<?, ?>) value, out, prefix + key);
                }
            }
        }
    }

    public static Map<?, ?> asMap(final Object im) {
        Map<?, ?> m = null;
        try {
            m = ValueUtils.asMapOrNull(im);
        } catch (JsonUnexpectedTokenException e) {
        }
        return m;
    }

    public static Map<String, Object> mergeJson(
        final Map<?, ?> in1,
        final Map<?, ?> in2)
    {
        Map<String, Object> result = new HashMap<>();
        try {
            putAll(in1, result);
            for (Map.Entry<?, ?> x : in2.entrySet()) {
                String key = ValueUtils.asString(x.getKey());
                Object value = x.getValue();
                if (result.containsKey(key)) {
                    Object resValue = result.get(key);
                    if (value instanceof Map && resValue instanceof Map) {
                        result.put(
                            key,
                            mergeJson(
                                ValueUtils.asMap(value),
                                ValueUtils.asMap(resValue)));
                    } else {
                        result.put(key, mergeFields(value, resValue));
                    }
                } else {
                    result.put(key, value);
                }
            }
        } catch (JsonUnexpectedTokenException e) {
        }
        return result;
    }

    public static Object mergeFields(final Object v1, final Object v2)
        throws JsonUnexpectedTokenException
    {
        Object res;
        if (v1 == null) {
            res = v2;
        } else if (v2 == null) {
            res = v1;
        } else if (v1.equals(v2)) {
            res = v1;
        } else if (v1 instanceof String && v2 instanceof String) {
            String v1str = ValueUtils.asString(v1);
            String v2str = ValueUtils.asString(v2);
            if (v1str.contains(v2str)) {
                res = v1str;
            } else if (v2str.contains(v1str)) {
                res = v2str;
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(v1str);
                if (!v1str.isEmpty() && !v2str.isEmpty()) {
                    sb.append(',');
                }
                sb.append(v2str);
                res = sb.toString();
            }
        } else if (v1 instanceof List && v2 instanceof List) {
            List<Object> r = new ArrayList<>();
            r.addAll(ValueUtils.asList(v1));
            r.addAll(ValueUtils.asList(v2));
            res = r;
        } else {
            List<Object> r = new ArrayList<>();
            r.add(v1);
            r.add(v2);
            res = r;
        }
        return res;
    }

    public static void trimJson(final Map<?, ?> tt) {
        for (Map.Entry<?, ?> x : tt.entrySet()) {
            String key;
            try {
                key = ValueUtils.asString(x.getKey());
            } catch (JsonUnexpectedTokenException e) {
                continue;
            }
            Object value = x.getValue();
            if (value instanceof String) {
                try {
                    pushToMap(tt, key, ValueUtils.asString(value).trim());
                } catch (JsonUnexpectedTokenException e) {
                    continue;
                }
            } else if (value instanceof Map) {
                try {
                    trimJson(ValueUtils.asMap(value));
                } catch (JsonUnexpectedTokenException e) {
                    continue;
                }
            }
        }
    }

    public static void putAll(final Object in, final Map<String, Object> out)
        throws JsonUnexpectedTokenException
    {
        if (in instanceof Map) {
            Map<?, ?> value = ValueUtils.asMap(in);
            for (Map.Entry<?, ?> x : value.entrySet()) {
                String key = ValueUtils.asString(x.getKey());
                Object vl = x.getValue();
                out.put(key, vl);
            }
        }
    }

    public static void addStr(
        final Map<String, Object> in,
        final String key,
        final String valueToAdd)
    {
        String r = "";
        if (in.containsKey(key)) {
            r += in.get(key);
            r += ", ";
        }
        r += valueToAdd;
        in.put(key, r);
    }

    public static void renameKey(
        final Map<String, Object> in,
        final String oldName,
        final String newName)
    {
        if (in != null && in.containsKey(oldName)) {
            final Object tmp = in.get(oldName);
            in.remove(oldName);
            in.put(newName, tmp);
        }
    }

    public static void removeEntry(
        final Map<String, Object> in,
        final String key)
    {
        if (in.containsKey(key)) {
            in.remove(key);
        }
    }

    public static void copyEntry(
        final String key,
        final Map<String, Object> in,
        final Map<String, Object> out)
    {
        if (in.containsKey(key)) {
            out.put(key, in.get(key));
        }
    }

    public static boolean copyEntryObjectAsMap(
        final String key,
        final Object in,
        final Map<String, Object> out)
    {
        try {
            if (in instanceof Map) {
                return copyEntryAs(key, key, ValueUtils.asMap(in), out);
            }
        } catch (JsonUnexpectedTokenException e) {
        }
        return false;
    }

    // CSOFF: ParameterNumber
    public static boolean copyEntryAs(
        final String key,
        final String newKey,
        final Map<?, ?> in,
        final Map<String, Object> out)
    {
        Object v = in.get(key);
        if (v != null) {
            out.put(newKey, v);
            return true;
        }
        return false;
    }
    // CSON: ParameterNumber

    public static Object getIfKeyExists(final Map<?, ?> in, final String key) {
        if (in == null) {
            return null;
        }
        return in.get(key);
    }

    /*
    public static void putIfValueIsString(
        final Map<String, Object> out,
        final String key,
        final Object value)
    {
        if (value != null && value instanceof String) {
            out.put(key, value);
        }
    }*/

    public static boolean isMapContainPair(
        final Map<?, ?> m,
        final String key,
        final String value)
    {
        boolean result = false;
        if (m.containsKey(key)) {
            Object v = m.get(key);
            if (v instanceof String) {
                result = value.startsWith((String) v);
            } else if (v instanceof JsonString) {
                result = value.startsWith(((JsonString) v).asString());
            }
        }
        return result;
    }

    public static String getStrValueOrEmpty(
        final Map<String, Object> m,
        final String key)
    {
        String result = "";
        if (m != null) {
            Object v = m.get(key);
            if (v instanceof String) {
                result = (String) v;
            } else if (v instanceof JsonString) {
                result = ((JsonString) v).asString();
            }
        }
        return result;
    }

    public static Object getNodeByPathOrLastValid(
        final Object map,
        final String... args)
        throws JsonUnexpectedTokenException
    {
        Object result = map;
        for (final String arg : args) {
            Object tmp = getSubMapOfKey(result, arg);
            if (tmp == null) {
                return result;
            }
            result = tmp;
        }
        return result;
    }

    public static Object getNodeByPathOrNull(
        final Object map,
        final String... args)
        throws JsonUnexpectedTokenException
    {
        Object result = map;
        for (final String arg : args) {
            Object tmp = getSubMapOfKey(result, arg);
            if (tmp == null) {
                return null;
            }
            result = tmp;
        }
        return result;
    }

    public static Object getNodeByPathOrNullEless(
        final Object map,
        final String... args)
    {
        try {
            return getNodeByPathOrNull(map, args);
        } catch (JsonUnexpectedTokenException e) {
        }
        return null;
    }

    public static Object getSubMapOfKey(final Object map, final String key)
        throws JsonUnexpectedTokenException
    {
        if (map instanceof Map) {
            Map<?, ?> mp = ValueUtils.asMap(map);
            if (mp.containsKey(key)) {
                return mp.get(key);
            }
        }
        return null;
    }

    public static boolean deleteKeyIfEqualTo(
        final Object m,
        final String keyToFind,
        final String tarValue)
    {
        boolean res = false;
        if (m == null) {
            res = false;
        } else {
            if (m instanceof Map) {
                Map<?, ?> root = (Map<?, ?>) m;
                for (final Map.Entry<?, ?> entry : root.entrySet()) {
                    final Object key = entry.getKey();
                    if (!(key instanceof String)) {
                        continue;
                    }
                    final Object value = entry.getValue();
                    final String keyString = (String) key;
                    if (keyString.equals(keyToFind)
                        && value instanceof String
                        && tarValue.equals(value))
                    {
                        root.remove(keyString);
                        return true;
                    }
                    res = deleteKeyIfEqualTo(
                        entry.getValue(),
                        keyToFind,
                        tarValue);
                    if (res) {
                        break;
                    }
                }
            } else if (m instanceof List) {
                final List<?> root = (List<?>) m;
                for (final Object x : root) {
                    res = deleteKeyIfEqualTo(x, keyToFind, tarValue);
                    if (res) {
                        break;
                    }
                }
            } else {
                res = false;
            }
        }
        return res;
    }

    public static int countOfKeys(final Object m) {
        int result = 0;
        if (m == null) {
            result = 0;
        } else {
            if (m instanceof Map) {
                final Map<?, ?> root = (Map<?, ?>) m;
                for (final Map.Entry<?, ?> entry : root.entrySet()) {
                    final Object key = entry.getKey();
                    if (!(key instanceof String)) {
                        continue;
                    }
                    result += countOfKeys(entry.getValue()) + 1;
                }
            } else if (m instanceof List) {
                final List<?> root = (List<?>) m;
                for (final Object x : root) {
                    result += countOfKeys(x);
                }
            } else {
                result = 0;
            }
        }
        return result;
    }

    public static String getStrValue(
        final Map<?, ?> m,
        final String key)
    {
        String result = "";
        if (m != null) {
            Object v = m.get(key);
            if (v instanceof String) {
                result = (String) v;
            } else if (v instanceof JsonString) {
                result = ((JsonString) v).asString();
            }
        }
        return result;
    }

    public static String getStrValue(
        final Map<?, ?> m,
        final String key,
        final String dflt)
    {
        String result = dflt;
        if (m != null) {
            Object v = m.get(key);
            if (v instanceof String) {
                result = (String) v;
            } else if (v instanceof JsonString) {
                result = ((JsonString) v).asString();
            }
        }
        return result;
    }

    public static String findValueForKey(
        final Object m,
        final String keyToFind)
    {
        //TODO: replace this implementation to findObjectValueForKey(), cast it
        String result = "";
        if (m == null) {
            result = "";
        } else {
            if (m instanceof Map) {
                final Map<?, ?> root = (Map<?, ?>) m;
                for (final Map.Entry<?, ?> entry : root.entrySet()) {
                    final Object key = entry.getKey();
                    if (!(key instanceof String)) {
                        continue;
                    }
                    final Object value = entry.getValue();
                    final String keyString = (String) key;
                    if (keyString.equals(keyToFind)
                        && value instanceof String)
                    {
                        return (String) value;
                    }
                    result = findValueForKey(entry.getValue(), keyToFind);
                    if (!result.isEmpty()) {
                        break;
                    }
                }
            } else if (m instanceof List) {
                final List<?> root = (List<?>) m;
                for (final Object x : root) {
                    result = findValueForKey(x, keyToFind);
                    if (!result.isEmpty()) {
                        break;
                    }
                }
            } else {
                result = "";
            }
        }
        return result;
    }

    public static Object findObjectValueForKey(
        final Object m,
        final String keyToFind)
    {
        Object result = null;
        if (m == null) {
            result = null;
        } else {
            if (m instanceof Map) {
                final Map<?, ?> root = (Map<?, ?>) m;
                for (final Map.Entry<?, ?> entry : root.entrySet()) {
                    final Object key = entry.getKey();
                    if (!(key instanceof String)) {
                        continue;
                    }
                    final Object value = entry.getValue();
                    final String keyString = (String) key;
                    if (keyString.equals(keyToFind)) {
                        return value;
                    }
                    result = findObjectValueForKey(entry.getValue(), keyToFind);
                    if (result != null) {
                        break;
                    }
                }
            } else if (m instanceof List) {
                final List<?> root = (List<?>) m;
                for (final Object x : root) {
                    result = findObjectValueForKey(x, keyToFind);
                    if (result != null) {
                        break;
                    }
                }
            } else {
                result = null;
            }
        }
        return result;
    }

    public static boolean isThereField(
        final Object m,
        final String keyToFind)
    {
        boolean result = false;
        if (m != null) {
            if (m instanceof Map) {
                final Map<?, ?> root = (Map<?, ?>) m;
                for (final Map.Entry<?, ?> entry : root.entrySet()) {
                    final Object key = entry.getKey();
                    if (!(key instanceof String)) {
                        continue;
                    }
                    final String keyString = (String) key;
                    if (keyString.equals(keyToFind)) {
                        return true;
                    }
                    result = isThereField(entry.getValue(), keyToFind);
                    if (result) {
                        break;
                    }
                }
            } else if (m instanceof List) {
                final List<?> root = (List<?>) m;
                for (final Object x : root) {
                    result = isThereField(x, keyToFind);
                    if (result) {
                        break;
                    }
                }
            }
        }
        return result;
    }

    public static void pushToMap(
        final Object map,
        final String key,
        final Object value)
        throws JsonUnexpectedTokenException
    {
        if (map instanceof Map) {
            Map<?, ?> pmap = ValueUtils.asMap(map);
            @SuppressWarnings("unchecked")
            Map<String, Object> rmap = (Map<String, Object>) pmap;
            rmap.put(key, value);
        }
    }

    public static void pushToMapElessAndValueNotNull(
        final Object map,
        final String key,
        final Object value)
    {
        try {
            if (value != null) {
                pushToMap(map, key, value);
            }
        } catch (JsonUnexpectedTokenException e) {
        }
    }
}
