package ru.yandex.iex.proxy;

import java.util.logging.Level;

public final class XMessageToLog {
    private XMessageToLog() {
    }

    public static void warning(
        final AbstractEntityContext context,
        final String msg)
    {
        context.session().logger().warning(msg);
    }

    public static void error(
        final AbstractEntityContext context,
        final String msg,
        final Exception e)
    {
        context.session().logger().log(Level.SEVERE, msg, e);
    }

    public static void info(
        final AbstractEntityContext context,
        final String msg)
    {
        context.session().logger().info(msg);
    }

    public static void info(
        final AbstractContext context,
        final String msg)
    {
        context.session().logger().info(msg);
    }
}
