package ru.yandex.iex.proxy;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import org.xml.sax.SAXException;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.parser.html.BodyContentHandler;
import ru.yandex.parser.html.TextContentHandler;
import ru.yandex.parser.html.generated.HtmlProcessor;

public final class XStrAlgo {
    public static final String HTTP = "http";
    private static HashMap<Character, Character> charMapp = new HashMap<>();

    static {
        // number flight rules of char transform
        Character[] cyr = {'А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ж', 'З', 'И',
            'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х',
            'Ё', 'Й', 'Ц', 'Ш', 'Щ', 'Э', 'Ю', 'Я', 'Ъ', 'Ь', 'Ы'};
        Character[] lat = {'A', 'B', 'V', 'G', 'D', 'E', 'J', 'Z', 'I',
            'K', 'L', 'M', 'N', 'O', 'P', 'R', 'S', 'T', 'Y', 'F', 'X',
            'E', 'I', 'C', 'S', 'S', 'A', 'U', 'Y', 'T', 'M', 'Y'};
        for (int i = 0; i < Math.min(cyr.length, lat.length); ++i) {
            charMapp.put(cyr[i], lat[i]);
            charMapp.put(
                Character.toLowerCase(cyr[i]),
                Character.toLowerCase(lat[i]));
        }
    }

    private XStrAlgo() {
    }

    @SuppressWarnings("unused")
    public static int[] prefixFunction(final String s) {
        int[] prefix = new int[s.length()];
        int cur = 0;
        for (int i = 1; i < s.length(); ++i) {
            while (cur > 0 && s.charAt(cur) != s.charAt(i)) {
                cur = prefix[cur - 1];
            }
            if (s.charAt(cur) == s.charAt(i)) {
                ++cur;
            }
            prefix[i] = cur;
        }
        return prefix;
    }

    public static int[] zFunction(final String s) {
        int n = s.length();
        int[] z = new int[n];
        for (int i = 1, l = 0, r = 0; i < n; ++i) {
            if (i <= r) {
                z[i] = Math.min(r - i + 1, z[i - l]);
            }
            while (i + z[i] < n && s.charAt(z[i]) == s.charAt(i + z[i])) {
                ++z[i];
            }
            if (i + z[i] - 1 > r) {
                l = i;
                r = i + z[i] - 1;
            }
        }
        return z;
    }

    public static String trimmer(final String str, final Set<Character> chrs) {
        int l = 0;
        int r = str.length() - 1;
        while (l < str.length() && chrs.contains(str.charAt(l))) {
            ++l;
        }
        while (r >= 0 && chrs.contains(str.charAt(r))) {
            --r;
        }
        if (l > r) {
            return "";
        }
        return str.substring(l, r + 1);
    }

    public static String[] generateMailStatus(
        final Integer[] first,
        final Integer[] second,
        final Integer[] third)
    {
        String[] result =
            new String[first.length * second.length * third.length];
        int i = 0;
        for (Integer x : first) {
            for (Integer y : second) {
                for (Integer z : third) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(x);
                    sb.append('.');
                    sb.append(y);
                    sb.append('.');
                    sb.append(z);
                    result[i++] = sb.toString();
                }
            }
        }
        return result;
    }

    public static String fromCCtoSC(final String word) {
        final String regexp = "([a-z])([A-Z])";
        return word.replace("http://schema.org/", "")
            .replaceAll(regexp, "$1_$2")
            .toLowerCase(Locale.getDefault());
    }

    @SuppressWarnings({"unused", "StringSplitter"})
    public static boolean isUrlContainsDomainOnly(final String url) {
        String[] urlsParts = url.split("/+");
        boolean result = false;
        if (urlsParts.length > 0) {
            if (urlsParts[0].startsWith(HTTP)) {
                result = urlsParts.length <= 2;
            } else {
                result = urlsParts.length == 1
                    || (urlsParts.length == 2 && urlsParts[0].isEmpty());
            }
        }
        return result;
    }

    public static String completeUrl(final String url, final String scheme) {
        String result = url;
        if (!url.startsWith(HTTP)) {
            result = scheme + result;
        }
        return result;
    }

    public static String getOnlyDigitsAndSeps(final String s) {
        StringBuilder sb = new StringBuilder();
        for (Character x : s.replaceAll("&nbsp;", " ").toCharArray()) {
            if (Character.isDigit(x) || x.equals('.') || x.equals(',')
                || x.equals(' '))
            {
                sb.append(x);
            }
        }
        String result = sb.toString();
        if (!result.isEmpty()
            && (result.endsWith(".") || result.endsWith(",")))
        {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String getOnlyAlphabetic(final String s) {
        StringBuilder sb = new StringBuilder();
        for (Character x : s.toCharArray()) {
            if (Character.isAlphabetic(x)) {
                sb.append(x);
            }
        }
        return sb.toString();
    }

    public static String replaceRustoEng(final String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (char x : s.toCharArray()) {
            if (charMapp.containsKey(x)) {
                sb.append(charMapp.get(x));
            } else {
                sb.append(x);
            }
        }
        return sb.toString();
    }

    public static boolean substri(final String s, final String sub) {
        return s.toLowerCase(Locale.getDefault())
            .contains(sub.toLowerCase(Locale.getDefault()));
    }

    public static boolean isMapValueContains(
        final Map<?, ?> x,
        final String key,
        final String sub)
    {
        return x.containsKey(key) && substri(x.get(key).toString(), sub);
    }

    public static <T> void swap(final T[] a, final int i, final int j) {
        T t = a[i];
        a[i] = a[j];
        a[j] = t;
    }

    @SuppressWarnings("unused")
    public static <T> void swap(final List<T> l, final int i, final int j) {
        Collections.swap(l, i, j);
    }

    @SuppressWarnings({"unused", "StringSplitter"})
    public static String siteNameFromUrl(final String url) {
        final String[] name = url.split("\\.");
        if (name.length >= 2) {
            return name[name.length - 2];
        }
        return url;
    }

    public static class Pair {
        private String first = "";
        private String second = "";

        public String getValue() {
            return first;
        }

        public void setFirst(final String label) {
            this.first = label;
        }

        public String getLabel() {
            return second;
        }

        public void setSecond(final String value) {
            this.second = value;
        }
    }

    public static String htmlSanitizer(final String s) {
        StringBuilderWriter sbw = new StringBuilderWriter();
        try {
            new HtmlProcessor(
                new BodyContentHandler(
                    new TextContentHandler(sbw))).process(new StringReader(s));
        } catch (IOException e) {
        } catch (SAXException e) {
        }
        return sbw.toString();
    }
}
