package ru.yandex.iex.proxy;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class XTools {
    public static final int RADIX = 16;
    private static MessageDigest md;

    static {
        try {
            md = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException e) {
            md = null;
        }
    }

    private XTools() {
    }

    public static int getMinimumNotNull(final int[] a) {
        int r = a.length + 1;
        if (a.length > 1) {
            for (int x : a) {
                if (x != 0) {
                    r = Math.min(r, x);
                }
            }
        }
        return r;
    }

    public static ArrayList<String> uniq(final ArrayList<String> value) {
        Set<String> hs = new HashSet<>();
        hs.addAll(value);
        value.clear();
        value.addAll(hs);
        return value;
    }

    public static Integer[] range(final int a, final int b) {
        int len = b - a + 1;
        Integer[] result = new Integer[len];
        int j = 0;
        for (int i = a; i <= b; ++i) {
            result[j++] = i;
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    public static <T> T[] concatAll(final T[] first, final T[]... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static String slowMd5hex(final String s)
        throws NoSuchAlgorithmException, UnsupportedEncodingException
    {
        if (md != null) {
            byte[] bytesOfMessage = s.getBytes("UTF-8");
            byte[] thedigest = md.digest(bytesOfMessage);
            return new BigInteger(1, thedigest).toString(RADIX);
        }
        return "";
    }
}
