package ru.yandex.iex.proxy.advpaymenthandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class AdvPaymentContext extends AbstractEntityContext {
    public static final String ADV_PAYMENT = "adv_payment";
    public static final String XPATH_LIST_DELIMITER = "\\|";
    private ArrayList<Map<?,?>> advPaymentResponse;

    public AdvPaymentContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        advPaymentResponse = new ArrayList<>();
        Map<?, ?> advPaymentCokeResponse = null;
        if (json != null && json.get(ADV_PAYMENT) != null) {
            List<?> listResponses = ValueUtils.asList(json.get(ADV_PAYMENT));
            int maxResponseSize = 0;
            for (Object response : listResponses) {
                int responseSize = ((Map<?, ?>) response).size();
                if (responseSize > maxResponseSize) {
                    advPaymentCokeResponse = ValueUtils.asMap(response);
                    maxResponseSize = responseSize;
                }
            }
        }
        if (advPaymentCokeResponse != null) {
            ArrayList<Map<Object,Object>> transposedResponse
                = new ArrayList<>();
            Map<Object, Object> generalData = new HashMap<>();
            String fromEmail = session.params().getOrNull("email");
            boolean isFacebook = fromEmail.equals("advertise-noreply@support.facebook.com");
            for (Map.Entry<?,?> entry : advPaymentCokeResponse.entrySet())  {
                String initialValue = entry.getValue().toString().
                    replaceAll("\\|\\|", "");
                if (initialValue.length() == 0) {
                    continue;
                }
                String[] values = initialValue.split(XPATH_LIST_DELIMITER);
                int i = 0;
                if (isFacebook &&
                        (entry.getKey().equals("total")
                         || entry.getKey().equals("account_id")
                         || entry.getKey().equals("dates_range"))
                ) {
                    generalData.put(entry.getKey(), values[0].replaceAll("\u00a0","").trim());
                } else {
                    for (String v : values) {
                        String trimmedValue = v.replaceAll("\u00a0","").trim();
                        if (transposedResponse.size() <= i) {
                            Map<Object, Object> map = new HashMap<>();
                            map.put(entry.getKey(), trimmedValue);
                            transposedResponse.add(map);
                        } else {
                            transposedResponse.get(i).put(entry.getKey(), trimmedValue);
                        }
                        ++i;
                    }
                }
            }
            if (isFacebook) {
                generalData.put("details", transposedResponse);
                advPaymentResponse.add(generalData);
            } else { // currently only "payments-noreply@google.com"
                if (transposedResponse.size() > 0) {
                    Map<Object, Object> wrapWithDetails = new HashMap<>();
                    wrapWithDetails.put("details", transposedResponse);
                    advPaymentResponse.add(wrapWithDetails);
                }
            }
        }
    }

    @Override
    public void response() {
        session.response(
            HttpStatus.SC_OK,
            JsonType.NORMAL.toString(advPaymentResponse));
    }
}
