package ru.yandex.iex.proxy.advpaymenthandler;

import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumer;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StringCollectorsFactory;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.mail.search.MailSearchParams;
import ru.yandex.search.document.mail.MailMetaInfo;

public class AdvPaymentDirectHandler implements HttpAsyncRequestHandler<JsonObject> {

    private final IexProxy proxy;
    private final Pattern pLogin = Pattern.compile("На Ваш счет логина (.*) поступила оплата в размере (.*) (?:Кампани|На данный).*");
    private final Pattern pCampaign = Pattern.compile("На Ваш счет поступила оплата кампании (.*) \\(.*\\) в размере (.*) (?:Кампани|На данный).*");

    public AdvPaymentDirectHandler(final IexProxy proxy) throws IOException {
        this.proxy = proxy;
    }

    @Override
    public HttpAsyncRequestConsumer<JsonObject> processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException
    {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            throw new BadRequestException("Payload expected");
        }
        return new JsonAsyncTypesafeDomConsumer(
            ((HttpEntityEnclosingRequest) request).getEntity(),
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }

    @Override
    public void handle(
        final JsonObject payload,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session = new BasicProxySession(proxy, exchange, context);
        String stid = session.params().getString(MailSearchParams.STID);
        Long uid = session.params().getLong(MailSearchParams.UID);

        if (!BlackboxUserinfo.corp(uid)) {
            BasicAsyncRequestProducerGenerator requestGenerator =
                new BasicAsyncRequestProducerGenerator(
                    "/mail/handler?json-type=dollar&ultra-fast-mode&stid="
                    + stid);
            requestGenerator.addHeader(
                YandexHeaders.X_YA_SERVICE_TICKET,
                proxy.tikaiteTvm2Ticket());
            requestGenerator.addHeader(
                YandexHeaders.X_SRW_SERVICE_TICKET,
                proxy.unistorageTvm2Ticket());
            AsyncClient client = proxy.tikaiteClient().adjust(context);
            client.execute(
                proxy.tikaiteHost(),
                requestGenerator,
                JsonAsyncTypesafeDomConsumerFactory.OK,
                session.listener().createContextGeneratorFor(client),
                new TikaiteCallback(session, uid, stid, context));
        } else {
            session.response(
                HttpStatus.SC_OK,
                JsonType.NORMAL.toString(Collections.emptyMap()));
        }
    }

    private final class TikaiteCallback implements FutureCallback<JsonObject> {
        private final Logger logger;
        private final Long uid;
        private final String mid;
        private final String stid;
        private final ProxySession session;
        private final HttpContext context;

        // CSOFF: ParameterNumber
        private TikaiteCallback(
            final ProxySession session,
            final Long uid,
            final String stid,
            final HttpContext context)
            throws BadRequestException
        {
            this.logger = session.logger();
            this.session = session;
            this.uid = uid;
            this.stid = stid;
            this.mid = session.params().getString(MailSearchParams.MID);
            this.context = context;
        }
        // CSON: ParameterNumber

        @Override
        public void completed(final JsonObject result) {
            logger.info("adv_payment direct, in tikaite completed ");
            try {
                String subject = "";
                String body = "";
                for (JsonObject docObj: result.get("docs").asList()) {
                    JsonMap doc = docObj.asMap();
                    final String contentType =
                        doc.getOrNull(MailMetaInfo.CONTENT_TYPE);
                    if ((contentType.equals("text/html")
                           || contentType.equals("text/plain"))
                           && doc.getOrNull(MailMetaInfo.ATTACHSIZE) == null)
                    {
                        subject = doc.getOrNull("hdr_subject").trim();
                        logger.info("subject = " + subject);
                        body = doc.getOrNull("pure_body").trim();
                        logger.info("body = " + body);
                        break;
                    }
                }
                String stringResponse = JsonType.NORMAL.toString(Collections.emptyMap());
                if (subject.contains("Яндекс.Директ/Поступила")) {
                    logger.info("adv_payment_direct, will extract info");
                    StringBuilderWriter sbw =
                        new StringBuilderWriter(new StringBuilder(""));
                    try (JsonWriter writer = new JsonWriter(sbw)) {
                        writer.startObject();
                        String campaign = "оплата кампании";
                        String idValue = "";
                        String amount = "";
                        Matcher matcher;
                        if (body.contains(campaign)) {
                            writer.key("adv_type");
                            matcher = pCampaign.matcher(body);
                        } else {
                            writer.key("client_id");
                            matcher = pLogin.matcher(body);
                        }
                        if (matcher.find()) {
                            idValue = matcher.group(1);
                            amount = matcher.group(2);
                        }
                        writer.value(idValue.trim());
                        writer.key("amount");
                        writer.value(amount.trim());
                        writer.endObject();

                        session.response(
                                HttpStatus.SC_OK,
                                JsonType.NORMAL.toString(sbw.toString()));
                    } catch (IOException e) {
                        session.logger().
                            info("AdvPaymentDirectHandler: exception while processing tikaite response");
                        session.response(
                                HttpStatus.SC_OK,
                                JsonType.NORMAL.toString(Collections.emptyMap()));
                    }
                } else {
                    session.response(
                            HttpStatus.SC_OK,
                            JsonType.NORMAL.toString(Collections.emptyMap()));
                }

            } catch (JsonException je) {
                failed(je);
            }
        }

        @Override
        public void failed(final Exception e) {
            logger.info("Tikaite failed");
            logger.log(Level.WARNING, "Tikaite failed with", e);
        }

        @Override
        public void cancelled() {
            logger.warning("Cancelled");
        }
    }

}
