package ru.yandex.iex.proxy.afisha;

import java.nio.charset.CharacterCodingException;
import java.util.Map;

import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.iex.proxy.XRegexpUtils;
import ru.yandex.iex.proxy.eventtickethandler.EventCallback;
import ru.yandex.iex.proxy.eventtickethandler.EventTicketContext;
import ru.yandex.iex.proxy.eventtickethandler.EventTicketHandler;
import ru.yandex.iex.proxy.xutils.CitiesUtils;
import ru.yandex.json.writer.JsonType;

public class AfishaCallback extends EventCallback {
    private String city = null;
    private String date = null;
    private String cinemaTitle = null;

    public AfishaCallback(final EventCallback callback) {
        super(callback);
    }

    @Override
    public void act(final EventTicketContext context) {
        Map<String, Object> solution = context.getOutputJson();
        Object location = solution.get(EventTicketHandler.LOCATION);
        if (location instanceof Map) {
            Object city = XJsonUtils.getNodeByPathOrNullEless(
                location,
                EventTicketHandler.CITY);
            if (city instanceof String) {
                this.city = CitiesUtils.ru2en((String) city);
            }
            Object name = XJsonUtils.getNodeByPathOrNullEless(
                location,
                EventTicketHandler.NAME);
            if (name instanceof String) {
                cinemaTitle = (String) name;
            }
        }
        Object date = solution.get(EventTicketHandler.START_DATE);
        if (date instanceof String) {
            String dateStr = (String) date;
            this.date = XRegexpUtils.toISODate(dateStr.split("\\s")[0]);
        }
    }

    @Override
    public void execute(final EventTicketContext context) {
        context.log("AfishaCallback, in execute, city = " + city
                + ", date = " + date
                + ", cinemaTitle = " + cinemaTitle);
        this.context = context;
        act(context);
        /*if (city == null || date == null || cinemaTitle == null) {
            completed(null);
            return;
        }*/

        AfishaClient client = context.iexProxy().afishaClient().adjust(
            context.session().context());
        try {
            client.execute(
                context.iexProxy(),
                city,
                date,
                context.session()
                    .listener().createContextGeneratorFor(client),
                this);
        } catch (CharacterCodingException e) {
            context.log("AfishaCallback, caught CharacterCodingException");
            completed(null);
        }
    }

    @Override
    public void completed(final Object result) {
        // mock for currently hardcoded ids and date
        // result is HttpEntity with gzip compressed response
        // the example of response may be found in
        // test/resources/ru/yandex/iex/proxy/afisha_response.json
        context.log("AfishaCallback, completed with "
            + JsonType.NORMAL.toString(result) + ", result is not used yet");
        /*if (context != null && result != null && result instanceof JsonMap) {
            JsonMap mapResult = (JsonMap) result;
            Map<String, Object> afishaMap = new HashMap<>();
            afishaMap.put("afisha_status", mapResult.get("status"));
            context.log("afisha map is " + JsonType.NORMAL.toString(afishaMap));
            context.getOutputJson().put("afisha", afishaMap);
        } else {
            context.log("AfishaCallback completed but with no suitable result");
        }*/
        callback.execute(context);
    }
}
