package ru.yandex.iex.proxy.afisha;

import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.HttpHeaders;
import org.apache.http.HttpHost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.NByteArrayEntityAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.afisha.config.ImmutableAfishaConfig;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonWriter;

public class AfishaClient extends AbstractAsyncClient<AfishaClient> {
    private final HttpHost host;
    private final String uri;
    private final Logger logger;

    public AfishaClient(
        final SharedConnectingIOReactor reactor,
        final ImmutableAfishaConfig afishaConfig)
    {
        super(reactor, afishaConfig);
        logger = reactor.logger();
        host = afishaConfig.host();
        StringBuilder sb =
            new StringBuilder(
                "/graphql?query_name=");
                //"/3.x/events/5575fad0cc1c725c1b9865f4/schedule?origin=");
        sb.append(afishaConfig.queryName());
        uri = new String(sb);
    }

    public AfishaClient(
        final CloseableHttpAsyncClient client,
        final AfishaClient sample)
    {
        super(client, sample);
        logger = sample.logger;
        host = sample.host;
        uri = sample.uri;
    }

    @Override
    protected AfishaClient adjust(final CloseableHttpAsyncClient client) {
        return new AfishaClient(client, this);
    }

    // CSOFF: ParameterNumber
    @SuppressWarnings("FutureReturnValueIgnored")
    public void execute(
        final IexProxy iexproxy,
        final String city,
        final String date,
        final Supplier<? extends HttpClientContext> contextGenerator,
        final FutureCallback<Object> callback)
        throws CharacterCodingException
    {
        StringBuilderWriter sbw =
            new StringBuilderWriter(new StringBuilder(""));
        try (JsonWriter writer = new JsonWriter(sbw)) {
            writer.startObject();
            writer.key("query");
            String queryVal = "query($eventId: ID!, $date: Date!)"
                    + " {eventScheduleCinema(id: $eventId date: $date paging:"
                    + " { limit: 300, offset: 0 } )"
                    + " {items {place {id title address}}}}";
            writer.value(queryVal);
            writer.key("variables");
            writer.startObject();
            writer.key("eventId");
            writer.value("5575fad0cc1c725c1b9865f4"); // mock
            writer.key("date");
            writer.value("2019-09-29"); // another mock, for short response
//            writer.value(date);
            writer.endObject();
            writer.endObject();
            logger.log(
                    Level.INFO,
                    "Executing afisha request " + sbw.toString());
        } catch (IOException e) {
            logger.log(
                    Level.INFO,
                    "Exception while constructing afisha request");
            callback.completed(null);
        }
        BasicAsyncRequestProducerGenerator generator =
            new BasicAsyncRequestProducerGenerator(uri, sbw.toString());
        generator.addHeader(
                YandexHeaders.X_YA_SERVICE_TICKET,
                iexproxy.afishaTvm2Ticket());
        generator.addHeader(HttpHeaders.ACCEPT_ENCODING, "gzip");
        generator.addHeader(
                HttpHeaders.CONTENT_TYPE,
                ContentType.APPLICATION_JSON.toString());
        generator.addHeader(
                HttpHeaders.ACCEPT,
                ContentType.APPLICATION_JSON.toString());
        execute(
            host,
            generator,
            NByteArrayEntityAsyncConsumerFactory.OK,
            contextGenerator,
            callback);
    }
    // CSON: ParameterNumber
}
