package ru.yandex.iex.proxy.afisha;

import java.util.List;
import java.util.Objects;

import ru.yandex.iex.proxy.afisha.result.AfishaResultBuilder;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.xpath.PathComponent;
import ru.yandex.json.xpath.PrimitiveHandler;

public class AfishaHandler implements PrimitiveHandler {
    public static final int FIVE = 5;
    public static final String GROUP = "group";
    public static final String PLACE = "place";
    public static final String DATA = "data";
    private final AfishaResultBuilder builder;

    public AfishaHandler(final AfishaResultBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void handle(final List<PathComponent> path, final Object value)
        throws JsonException
    {
        if (isSize(path)) {
            int size = parseInt(value);
            builder.setSize(size);
        } else if (isEventId(path)) {
            builder.addId(Objects.toString(value));
        } else if (isAddress(path)) {
            builder.addAddress(Objects.toString(value));
        } else if (isTitle(path)) {
            builder.addTitle(Objects.toString(value));
        }
    }

    private static int parseInt(final Object value) throws JsonException {
        if (value instanceof Number) {
            return ((Number) value).intValue();
        }
        try {
            return Integer.parseInt(Objects.toString(value));
        } catch (NumberFormatException e) {
            throw new JsonException(e);
        }
    }

    private static boolean isNameEquals(
        final List<PathComponent> path,
        final int index,
        final String name)
    {
        return path.get(index).name().equals(name);
    }

    private static boolean isIndexLessThan(
        final List<PathComponent> path,
        final int index,
        final int limit)
    {
        PathComponent comp = path.get(index);
        return comp.name() == null && comp.index() < limit;
    }

    private boolean isSize(final List<PathComponent> path) {
        int comp = 0;
        return path.size() == 2
            && isNameEquals(path, comp++, "paging")
            && (isNameEquals(path, comp, "total")
            || isNameEquals(path, comp, "limit"));
    }

    private boolean isEventId(final List<PathComponent> path) {
        int comp = 0;
        return path.size() == FIVE
            && isNameEquals(path, comp++, DATA)
            && isIndexLessThan(path, comp++, builder.size() + 1)
            && isNameEquals(path, comp++, GROUP)
            && isNameEquals(path, comp++, PLACE)
            && isNameEquals(path, comp, "id");
    }

    public boolean isTitle(final List<PathComponent> path) {
        int comp = 0;
        return path.size() == FIVE
            && isNameEquals(path, comp++, DATA)
            && isIndexLessThan(path, comp++, builder.size() + 1)
            && isNameEquals(path, comp++, GROUP)
            && isNameEquals(path, comp++, PLACE)
            && isNameEquals(path, comp, "title");
    }

    public boolean isAddress(final List<PathComponent> path) {
        int comp = 0;
        return path.size() == FIVE
            && isNameEquals(path, comp++, DATA)
            && isIndexLessThan(path, comp++, builder.size() + 1)
            && isNameEquals(path, comp++, GROUP)
            && isNameEquals(path, comp++, PLACE)
            && isNameEquals(path, comp, "address");
    }
}
