package ru.yandex.iex.proxy.afisha.config;

import ru.yandex.http.config.AbstractHttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveIntegerValidator;

public abstract class AbstractAfishaConfigBuilder
    <T extends AbstractAfishaConfigBuilder<T>>
    extends AbstractHttpHostConfigBuilder<T>
    implements InterfaceAfishaConfig
{
    private int limit;
    private String origin;
    private String queryName;

    protected AbstractAfishaConfigBuilder(final InterfaceAfishaConfig config) {
        super(config);
        limit = config.limit();
        origin = config.origin();
        queryName = config.queryName();
    }

    protected AbstractAfishaConfigBuilder(
        final IniConfig config,
        final InterfaceAfishaConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        limit = config.get(
            "limit",
            defaults.limit(),
            PositiveIntegerValidator.INSTANCE);
        origin = config.get(
            "origin",
            defaults.origin(),
            NonEmptyValidator.INSTANCE);
        queryName = config.get(
            "query_name",
            defaults.queryName(),
            NonEmptyValidator.INSTANCE);
    }

    @Override
    public int limit() {
        return limit;
    }

    public T limit(final int limit) {
        this.limit = limit;
        return self();
    }

    @Override
    public String origin() {
        return origin;
    }

    public T origin(final String origin) {
        this.origin = origin;
        return self();
    }

    @Override
    public String queryName() {
        return queryName;
    }

    public T queryName(final String queryName) {
        this.queryName = queryName;
        return self();
    }
}
