package ru.yandex.iex.proxy.afisha.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class AfishaConfigBuilder
    extends AbstractAfishaConfigBuilder<AfishaConfigBuilder>
{
    public AfishaConfigBuilder() {
        super(AfishaConfigDefauls.INSTANCE);
    }

    public AfishaConfigBuilder(final InterfaceAfishaConfig config) {
        super(config);
    }

    public AfishaConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, AfishaConfigDefauls.INSTANCE);
    }

    public AfishaConfigBuilder(
        final IniConfig config,
        final InterfaceAfishaConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public AfishaConfigBuilder self() {
        return this;
    }

    public ImmutableAfishaConfig build() throws ConfigException {
        return new ImmutableAfishaConfig(this);
    }
}
