package ru.yandex.iex.proxy.afisha.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableAfishaConfig
    extends ImmutableHttpHostConfig
    implements InterfaceAfishaConfig
{
    private final int limit;
    private final String origin;
    private final String queryName;

    public ImmutableAfishaConfig(final InterfaceAfishaConfig config)
        throws ConfigException
    {
        super(config);
        limit = config.limit();
        origin = config.origin();
        queryName = config.queryName();
    }

    @Override
    public int limit() {
        return limit;
    }

    @Override
    public String origin() {
        return origin;
    }

    @Override
    public String queryName() {
        return queryName;
    }
}
