package ru.yandex.iex.proxy.afisha.consumer;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.iex.proxy.afisha.AfishaHandler;
import ru.yandex.iex.proxy.afisha.result.AfishaResultBuilder;
import ru.yandex.iex.proxy.afisha.result.InterfaceAfishaResult;
import ru.yandex.json.async.consumer.JsonAsyncConsumer;
import ru.yandex.json.parser.KeyInterningSparseStringCollectorsFactory;

public class AfishaConsumer extends JsonAsyncConsumer<InterfaceAfishaResult> {
    private final AfishaResultBuilder builder;

    public AfishaConsumer(final HttpEntity entity) throws HttpException {
        this(entity, new AfishaResultBuilder());
    }

    private AfishaConsumer(
        final HttpEntity entity,
        final AfishaResultBuilder builder)
        throws HttpException
    {
        super(
            entity,
            new AfishaHandler(builder),
            KeyInterningSparseStringCollectorsFactory.INSTANCE);
        this.builder = builder;
    }

    @Override
    protected InterfaceAfishaResult doBuildResult(final HttpContext context) {
        return builder.build();
    }
}
