package ru.yandex.iex.proxy.afisha.consumer;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;
import ru.yandex.iex.proxy.afisha.result.InterfaceAfishaResult;

public class AfishaConsumerFactory
    implements HttpAsyncResponseConsumerFactory<InterfaceAfishaResult>
{
    public static final AfishaConsumerFactory INSTANCE =
        new AfishaConsumerFactory();
    public static final HttpAsyncResponseConsumerFactory<InterfaceAfishaResult>
        OK = new StatusCheckAsyncResponseConsumerFactory<>(
        HttpStatusPredicates.OK,
        INSTANCE);

    protected AfishaConsumerFactory() {
    }

    @Override
    public AfishaConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new AfishaConsumer(response.getEntity());
    }
}
