package ru.yandex.iex.proxy.afisha.result;

import java.util.ArrayList;

public class AfishaResultBuilder implements InterfaceAfishaResult {
    private int size = Integer.MAX_VALUE - 1;
    private ArrayList<String> id = new ArrayList<>();
    private ArrayList<String> title = new ArrayList<>();
    private ArrayList<String> address = new ArrayList<>();

    public AfishaResultBuilder() {
    }

    public InterfaceAfishaResult build() {
        return new ImmutableAfishaResult(this);
    }

    public AfishaResultBuilder setSize(final int size) {
        this.size = Math.min(this.size, size);
        return this;
    }

    public AfishaResultBuilder addId(final String id) {
        this.id.add(id);
        return this;
    }

    public AfishaResultBuilder addTitle(final String title) {
        this.title.add(title);
        return this;
    }

    public AfishaResultBuilder addAddress(final String address) {
        this.address.add(address);
        return this;
    }

    @Override
    public int size() {
        return size;
    }

    @Override
    public ArrayList<String> id() {
        return id;
    }

    @Override
    public ArrayList<String> title() {
        return title;
    }

    @Override
    public ArrayList<String> address() {
        return address;
    }
}
