package ru.yandex.iex.proxy.afisha.result;

import java.util.ArrayList;

public class ImmutableAfishaResult implements InterfaceAfishaResult {
    private final int size;
    private final ArrayList<String> title;
    private final ArrayList<String> address;
    private final ArrayList<String> id;

    public ImmutableAfishaResult(final InterfaceAfishaResult result) {
        size = result.size(); // count of films
        id = result.id();
        title = result.title();
        address = result.address();
    }

    @Override
    public int size() {
        return size;
    }

    @Override
    public ArrayList<String> address() {
        return address;
    }

    @Override
    public ArrayList<String> title() {
        return title;
    }

    @Override
    public ArrayList<String> id() {
        return id;
    }
}
