package ru.yandex.iex.proxy.cacheupdate;

import java.util.Map;
import java.util.Set;

public class CacheModificationSettings {
    private Set<Integer> emailTypes; // types of email to update cache for
    private String factName; // fact name to update cache for
    private String searchFieldName; // name of field in cache to find record by
    private Set<String> checkFieldNames; // set of fields to be equal
    private String modifiedMidFieldName; // name of filed to put modified mid
    private Map<String, FieldModificationSettings> fieldsModificationSettings;
    private final int dayAgeLimit;
    private final int updateDepth;

    // CSOFF: ParameterNumber
    public CacheModificationSettings(
        final Set<Integer> emailTypes,
        final String factName,
        final String searchFieldName,
        final Set<String> checkFieldNames,
        final String modifiedMidFieldName,
        final Map<String, FieldModificationSettings>
            fieldsModificationSettings,
        final int dayAgeLimit,
        final int updateDepth)
    {
        this.emailTypes = emailTypes;
        this.factName = factName;
        this.searchFieldName = searchFieldName;
        this.checkFieldNames = checkFieldNames;
        this.modifiedMidFieldName = modifiedMidFieldName;
        this.fieldsModificationSettings = fieldsModificationSettings;
        this.dayAgeLimit = dayAgeLimit;
        this.updateDepth = updateDepth;
    }
    // CSON: ParameterNumber

    public Set<Integer> emailTypes() {
        return emailTypes;
    }

    public String factName() {
        return factName;
    }

    public String searchFieldName() {
        return searchFieldName;
    }

    public Set<String> checkFieldNames() {
        return checkFieldNames;
    }

    public String modifiedMidFieldName() {
        return modifiedMidFieldName;
    }

    public Map<String, FieldModificationSettings> fieldsModificationSettings() {
        return fieldsModificationSettings;
    }

    public int dayAgeLimit() {
        return dayAgeLimit;
    }

    public int updateDepth() {
        return updateDepth;
    }
}
