package ru.yandex.iex.proxy.cacheupdate;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import ru.yandex.json.dom.JsonBoolean;
import ru.yandex.json.dom.JsonString;

public final class CacheModificationSettingsDefaults {
    public static final CacheModificationSettingsDefaults INSTANCE =
        new CacheModificationSettingsDefaults();

    public static final int ESHOP_UPDATE_AGE_LIMIT = 120; // Days
    public static final int ESHOP_UPDATE_DEPTH = 50; // Records

    private static final int TYPE_6 = 6;
    private static final int TYPE_23 = 23;
    private static final int TYPE_35 = 35;
    private static final int TYPE_42 = 42;

    private static final String HOTELS = "hotels";
    private static final String ESHOP = "eshop";
    private static final String CALENDAR = "calendar";

    private static final String WIDGET_SUBTYPE = "widget_subtype";
    private static final String UPDATER_MID = "updater_mid";

    private Map<String, CacheModificationSettings> entityNamesToSettings =
        new HashMap<>();

    private CacheModificationSettingsDefaults() {
        entityNamesToSettings.put(HOTELS, hotelsSettings());
        entityNamesToSettings.put(ESHOP, eshopSettings());
        entityNamesToSettings.put(CALENDAR, calendarSettings());
    }

    private CacheModificationSettings hotelsSettings() {
        FieldModificationSettings widgetSubtypeSettings =
            new FieldModificationSettings(
                "canceling",
                new JsonString("canceled"));
        return new CacheModificationSettings(
            Collections.singleton(TYPE_35),
            HOTELS,
            "uniq_id",
            Collections.singleton("reservation_number"),
            "cancel_mid",
            Collections.singletonMap(WIDGET_SUBTYPE, widgetSubtypeSettings),
            0,
            0);
    }

    private CacheModificationSettings eshopSettings() {
        Set<Integer> eshopTypes = new HashSet<>();
        eshopTypes.add(TYPE_6);
        eshopTypes.add(TYPE_23);
        FieldModificationSettings widgetSubtypeSettings =
            new FieldModificationSettings(ESHOP, new JsonString("updated"));
        return new CacheModificationSettings(
            eshopTypes,
            ESHOP,
            "order_number",
            Collections.emptySet(),
            UPDATER_MID,
            Collections.singletonMap(WIDGET_SUBTYPE, widgetSubtypeSettings),
            ESHOP_UPDATE_AGE_LIMIT,
            ESHOP_UPDATE_DEPTH);
    }

    private CacheModificationSettings calendarSettings() {
        Map<String, FieldModificationSettings> settings = new HashMap<>();
        FieldModificationSettings widgetSubtypeSettings =
            new FieldModificationSettings(
                CALENDAR,
                new JsonString("calendar-updated"),
                false,
                true);
        settings.put(WIDGET_SUBTYPE, widgetSubtypeSettings);
        FieldModificationSettings isCancelledSettings =
            new FieldModificationSettings(true, JsonBoolean.TRUE, false, false);
        settings.put("isCancelled", isCancelledSettings);
        return new CacheModificationSettings(
            Collections.singleton(TYPE_42),
            "event-ticket",
            "externalEventId",
            Collections.singleton("recurrenceEventId"),
            UPDATER_MID,
            settings,
            0,
            0);
    }

    public Set<String> entitiesFromKeys() {
        return entityNamesToSettings.keySet();
    }

    public CacheModificationSettings cacheModificationSettings(
        final String entityName)
    {
        return entityNamesToSettings.get(entityName);
    }
}
