package ru.yandex.iex.proxy.cacheupdate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;

import ru.yandex.client.producer.ProducerClient;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.iex.proxy.AbstractContext;
import ru.yandex.iex.proxy.IndexationContext;
import ru.yandex.iex.proxy.Solution;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.prefix.Prefix;

public class FactsCacheUpdater {
    private static final String LOG_PREFIX = "FactsCacheUpdater: ";

    private AbstractContext context;
    private String xIndexOperationQueueName;
    private List<PossibleUpdateCacheData> possibleModifyLuceneCache;

    public FactsCacheUpdater(
        final AbstractContext context,
        final String xIndexOperationQueueName)
    {
        this.context = context;
        this.xIndexOperationQueueName = xIndexOperationQueueName;
        possibleModifyLuceneCache = new ArrayList<>();
    }

    public void addCacheData(
        final IndexationContext<Solution> context,
        final Object factData,
        final Object eventId)
    {
        try {
            CacheModificationSettingsDefaults settings = CacheModificationSettingsDefaults.INSTANCE;
            Set<String> possibleEntities = new HashSet<>(context.entities().keySet());
            if (eventId != null) {
                possibleEntities.add("calendar");
            }
            possibleEntities.retainAll(settings.entitiesFromKeys());
            if (possibleEntities.isEmpty()) {
                return;
            }
            context.abstractContext().session().logger().info(LOG_PREFIX + " possible entities: " + possibleEntities);

            Long uid = ValueUtils.asLongOrNull(context.uid());
            Map<?, ?> factDataMap = ValueUtils.asMapOrNull(factData);

            for (String entityName : possibleEntities) {
                CacheModificationSettings entitySettings = settings.cacheModificationSettings(entityName);
                String searchFieldName = entitySettings.searchFieldName();
                context.abstractContext().session().logger().
                    info(LOG_PREFIX + "Looking for " + entityName + ", message types: "
                        + context.meta().messageTypes() + ", and looking to be in " + entitySettings.emailTypes());

                if (factDataMap == null || factDataMap.get(searchFieldName) == null
                    || !context.meta().messageTypes().containsAll(entitySettings.emailTypes()))
                {
                    continue;
                }
                Set<String> checkFieldNames = entitySettings.checkFieldNames();
                Map<String, String> checkFields = new HashMap<>();
                for (String fieldName: checkFieldNames) {
                    if (factDataMap.get(fieldName) != null) {
                        checkFields.put(fieldName, factDataMap.get(fieldName).toString());
                    }
                }
                if (checkFields.size() != checkFieldNames.size()) {
                    continue;
                }
                Map<String, FieldModificationSettings> suitableFieldSettings = new HashMap<>();

                for (Map.Entry<String, FieldModificationSettings> fieldSettings
                    : entitySettings.fieldsModificationSettings().entrySet())
                {
                    if (Objects.equals(
                        factDataMap.get(fieldSettings.getKey()),
                        fieldSettings.getValue().msgFieldValue()))
                    {
                        suitableFieldSettings.put(fieldSettings.getKey(), fieldSettings.getValue());
                    }
                }
                if (suitableFieldSettings.isEmpty()) {
                    continue;
                }

                context.abstractContext().session().logger().
                    info(LOG_PREFIX
                        + "From notify got updating request for entity "
                        + entityName + ", try to update cache for some emails earlier");
                String searchFieldValue = factDataMap.get(searchFieldName).toString();
                context.abstractContext().session().logger()
                    .info(LOG_PREFIX + "Request contains " + searchFieldName
                        + " field with value: " + searchFieldValue);
                PossibleUpdateCacheData possibleUpdateCacheData =
                    new PossibleUpdateCacheData(
                        uid,
                        context.mid(),
                        context.receivedDate(),
                        entitySettings,
                        suitableFieldSettings,
                        searchFieldValue,
                        checkFields);
                if (possibleUpdateCacheData.requestText() != null) {
                    possibleModifyLuceneCache.add(possibleUpdateCacheData);
                }
            }
        } catch (JsonUnexpectedTokenException e) {
            String data = (factData == null) ? "null" : factData.toString();
            context.abstractContext().session().logger().log(
                Level.WARNING,
                LOG_PREFIX + "json parse error, uid: " + context.uid() + ", mid: " + context.mid()
                    + ", data: " + data,
                e);
        }
    }

    @SuppressWarnings("FutureReturnValueIgnored")
    public void update(final MultiFutureCallback<Object> call) {
        if (possibleModifyLuceneCache.isEmpty()) {
            context.session().logger().info(
                LOG_PREFIX + "possibleModifyLuceneCache is empty for uid " + context.uid());
        }
        for (PossibleUpdateCacheData data: possibleModifyLuceneCache) {
            context.session().logger().
                info(LOG_PREFIX + "finding mid with updating info for uid " + data.uid() + ", mid " + data.mid());
            Prefix prefix = new LongPrefix(data.uid());
            String serviceName = context.iexProxy().config().factsIndexingQueueName();
            User user = new User(serviceName, prefix);
            ProducerClient producerClient = context.iexProxy().producerClient();
            producerClient.execute(
                user,
                context.session().listener().createContextGeneratorFor(producerClient),
                new HostsCallback(context, xIndexOperationQueueName, data, call.newCallback()));
        }
    }
}
